/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.xml;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcContent;
import com.scenari.xsldtm.xalan.processor.TransformerFactoryImpl;
import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class HTransformerXsl
extends HTransformer {
    protected String fMimType = "text/xml";
    protected String fExtension = ".xml";
    protected Templates fXsl = null;

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ISrcContent.class.isAssignableFrom(pClassSrc) || File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes);
    }

    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        InputStream vInput;
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        if (pSrc instanceof InputStream) {
            vInput = (InputStream)pSrc;
        } else if (pSrc instanceof ISrcContent) {
            vInput = ((ISrcContent)pSrc).newInputStream(false);
        } else {
            File vSrc = (File)pSrc;
            if (vSrc.isDirectory()) {
                vSrc = new File(vSrc, vSrc.getName());
            }
            vInput = new FileInputStream(vSrc);
        }
        OutputStream vResult = null;
        vResult = pRes instanceof OutputStream ? (OutputStream)pRes : new FileOutputStream((File)pRes);
        try {
            try {
                Transformer vTransformer = this.fXsl.newTransformer();
                vTransformer.setParameter("params", pParams);
                vTransformer.transform(new SAXSource(vXmlReader, new InputSource(vInput)), new StreamResult(vResult));
            }
            catch (Exception e) {
                try {
                    if (vInput != null) {
                        vInput.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                try {
                    if (vResult != null) {
                        vResult.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation XSL.", new String[0]);
            }
            Object var10_9 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            throw throwable;
        }
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        return this.fMimType;
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        return this.fExtension;
    }

    public void wSetProperty(String pKey, URL pUrl) {
        if (pKey.equals("xsl")) {
            try {
                this.fXsl = new TransformerFactoryImpl().newTemplates(new StreamSource(pUrl.toExternalForm()));
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Echec \u00e0 la compilation d'un template XSL '" + pUrl.toExternalForm() + "'", new String[0]);
            }
        }
    }

    public void wSetProperty(String pKey, String pValue) {
        if (pKey.equals("mimeType")) {
            this.fMimType = pValue;
        } else if (pKey.equals("fileExt")) {
            this.fExtension = pValue;
        }
    }

    public static void main(String[] pArgs) {
        try {
            HTransformerXsl vTrsf = new HTransformerXsl();
            vTrsf.wSetProperty("xsl", new URL("file:///C:/test.xsl"));
            HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString("transform=xsl", "UTF-8");
            vTrsf.hTransform(new File("C:\\sourceXml.xml"), new File("C:\\resultXsl.xml"), vParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

