/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.xml;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TransformerXml2FullText
extends HTransformer {
    public static final String SCNS = "http://www.utc.fr/ics/scenari/v3/core";
    public static final String ATT_REFURI = "refUri";
    public static final String ATT_ID = "id";
    public static int sBufferSize = 8192;

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        return File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes);
    }

    /*
     * Loose catch block
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        block20: {
            InputStream vInput;
            if (pSrc == null) {
                return;
            }
            if (pSrc instanceof InputStream) {
                vInput = (InputStream)pSrc;
            } else {
                File vSrc = (File)pSrc;
                if (vSrc.isDirectory()) {
                    vSrc = new File(vSrc, vSrc.getName());
                }
                if (!vSrc.isFile()) {
                    return;
                }
                vInput = new FileInputStream(vSrc);
            }
            OutputStream vResult = null;
            XMLReader vXmlReader = null;
            vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            vResult = pRes instanceof OutputStream ? (OutputStream)pRes : new FileOutputStream((File)pRes);
            TextGenerator vTextGen = new TextGenerator(vResult);
            vXmlReader.setContentHandler(vTextGen);
            vXmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", vTextGen);
            vXmlReader.parse(new InputSource(vInput));
            Object var10_9 = null;
            try {
                if (vResult != null) {
                    vResult.close();
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            if (vXmlReader != null) {
                HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
            }
            break block20;
            {
                catch (Exception e) {
                    try {
                        if (vInput != null) {
                            vInput.close();
                        }
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    throw (Exception)LogMgr.addMessage((Throwable)e, "Echec \u00e0 la transformation full-text.", new String[0]);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (vResult != null) {
                        vResult.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                if (vXmlReader != null) {
                    HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
                }
                throw throwable;
            }
        }
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        return "text/xx-application";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        return ".raw";
    }

    protected static class TextGenerator
    extends DefaultHandler
    implements LexicalHandler {
        protected ByteBuffer fBuf = ByteBuffer.allocate(sBufferSize);
        protected OutputStream fOutput;
        protected boolean fStartLine = true;
        protected boolean fPreviousIsSpace = false;

        public TextGenerator(OutputStream pOutput) {
            this.fOutput = pOutput;
        }

        public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
            int vEnd = pStart + pLength;
            for (int i = pStart; i < vEnd; ++i) {
                this.pushChar(pCh[i]);
            }
            this.pushBreak();
        }

        public void startElement(String pUri, String pLocalName, String pName, Attributes pAttributes) throws SAXException {
            int vLenAtts = pAttributes.getLength();
            for (int i = 0; i < vLenAtts; ++i) {
                String vLocalName;
                if (pAttributes.getURI(i).equals(TransformerXml2FullText.SCNS) && ((vLocalName = pAttributes.getLocalName(i)).equals(TransformerXml2FullText.ATT_REFURI) || vLocalName.equals(TransformerXml2FullText.ATT_ID))) continue;
                String vVal = pAttributes.getValue(i);
                int vLen = vVal.length();
                for (int j = 0; j < vLen; ++j) {
                    this.pushChar(vVal.charAt(j));
                }
                this.pushBreak();
            }
        }

        protected void pushBreak() throws SAXException {
            if (this.fStartLine) {
                return;
            }
            this.writeChar('\n');
            this.fPreviousIsSpace = true;
            this.fStartLine = true;
        }

        protected void pushChar(char pCh) throws SAXException {
            if (Character.isWhitespace(pCh)) {
                if (this.fStartLine) {
                    return;
                }
                if (!this.fPreviousIsSpace) {
                    this.fPreviousIsSpace = true;
                    this.writeChar(' ');
                    return;
                }
                return;
            }
            this.writeChar(pCh);
            this.fPreviousIsSpace = false;
            this.fStartLine = false;
        }

        protected void writeChar(char pCh) throws SAXException {
            try {
                if (this.fBuf.position() < sBufferSize) {
                    this.fBuf.putChar(pCh);
                } else {
                    this.fOutput.write(this.fBuf.array());
                    this.fBuf.clear();
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void comment(char[] pCh, int pStart, int pLength) throws SAXException {
            this.characters(pCh, pStart, pLength);
        }

        public void endDocument() throws SAXException {
            try {
                this.fOutput.write(this.fBuf.array(), 0, this.fBuf.position());
                this.fBuf.clear();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void endCDATA() throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void endEntity(String pName) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void startDTD(String pName, String pPublicId, String pSystemId) throws SAXException {
        }

        public void startEntity(String pName) throws SAXException {
        }
    }
}

