/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.co.transform.zip;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformer;
import com.scenari.serializer.simple.XmlWriterAppendable;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.fs.mini.FsMiniSrcNode;
import com.scenari.src.helpers.util.ZipperSrc;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.stream.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class HTransformerZip
extends HTransformer {
    public static final String TAG_ZIP = "zip";
    public static final String TAG_ENTRY = "entry";
    public static final String TAG_ENTRY_ATT_NAME = "name";
    public static final String TAG_ENTRY_ATT_SIZE = "size";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_ZIPMETHOD = "zipMethod";
    public static final String METHOD_DEFLATED = "deflated";
    public static final String PARAM_ROOTNAME = "rootName";
    public static final String PARAM_MIME = "mime";
    public static final String PARAM_EXT = "extension";

    public boolean hIsSrcAllowed(Class pClassSrc, HTransformParams pParams) {
        return ISrcNode.class.isAssignableFrom(pClassSrc) || File.class.isAssignableFrom(pClassSrc) || InputStream.class.isAssignableFrom(pClassSrc);
    }

    public boolean hIsResAllowed(Class pClassRes, HTransformParams pParams) {
        if (File.class.isAssignableFrom(pClassRes) || OutputStream.class.isAssignableFrom(pClassRes)) {
            return true;
        }
        if (pParams.hGetValueParam(PARAM_PATH) == null && pParams.hGetValueParam(PARAM_ZIPMETHOD) == null) {
            return Writer.class.isAssignableFrom(pClassRes);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hTransform(Object pSrc, Object pRes, HTransformParams pParams) throws Exception {
        ZipInputStream vZipIn;
        block27: {
            String vMethod = pParams.hGetValueParam(PARAM_ZIPMETHOD);
            if (vMethod != null && vMethod.equals(METHOD_DEFLATED)) {
                String vRootName = pParams.hGetValueParam(PARAM_ROOTNAME);
                OutputStream vOut = null;
                vOut = pRes instanceof File ? new FileOutputStream((File)pRes) : (OutputStream)pRes;
                try {
                    if (pSrc instanceof ISrcNode) {
                        ISrcNode vSrc = (ISrcNode)pSrc;
                        ZipperSrc vZipper = new ZipperSrc();
                        if (vRootName != null) {
                            vZipper.setRootFolderName(vRootName);
                        }
                        vZipper.zipSrcNode(vSrc, null, vOut);
                    } else if (pSrc instanceof File) {
                        File vSrcFile = (File)pSrc;
                        FsMiniSrcNode vSrc = FsMiniFactory.newNodeFromCanonicalFile(vSrcFile.getCanonicalFile(), true);
                        ZipperSrc vZipper = new ZipperSrc();
                        if (vRootName != null) {
                            vZipper.setRootFolderName(vRootName);
                        }
                        vZipper.zipSrcNode(vSrc, null, vOut);
                    } else {
                        InputStream vIn = (InputStream)pSrc;
                        if (vRootName == null) {
                            vRootName = "content";
                        }
                        ZipOutputStream vZipOutput = new ZipOutputStream(vOut);
                        try {
                            ZipEntry vEntry = new ZipEntry(vRootName);
                            vEntry.setTime(System.currentTimeMillis());
                            vZipOutput.putNextEntry(vEntry);
                            StreamUtils.write(vIn, vZipOutput);
                            vZipOutput.closeEntry();
                            Object var11_20 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_21 = null;
                            vZipOutput.finish();
                            throw throwable;
                        }
                        vZipOutput.finish();
                    }
                    Object var13_26 = null;
                }
                catch (Throwable throwable) {
                    Object var13_27 = null;
                    if (!(pRes instanceof File)) throw throwable;
                    vOut.close();
                    throw throwable;
                }
                if (!(pRes instanceof File)) return;
                vOut.close();
                return;
            }
            String vPath = pParams.hGetValueParam(PARAM_PATH);
            if (vPath == null) {
                this.xFillMapEntries(pSrc, pRes);
                return;
            }
            ZipFile vZipFile = null;
            vZipIn = null;
            try {
                InputStream vInputEntry = null;
                Object vSrc = this.xGetSrcFileOrStream(pSrc);
                if (vSrc instanceof File) {
                    File vFile = (File)vSrc;
                    vZipFile = new ZipFile(vFile);
                    ZipEntry vEntry = vZipFile.getEntry(vPath);
                    if (vEntry != null) {
                        vInputEntry = vZipFile.getInputStream(vEntry);
                    }
                } else {
                    InputStream vIn = (InputStream)vSrc;
                    vZipIn = new ZipInputStream(vIn);
                    ZipEntry vEntry = vZipIn.getNextEntry();
                    while (vEntry != null) {
                        if (vEntry.getName().equals(vPath)) {
                            vInputEntry = vZipIn;
                            break;
                        }
                        vEntry = vZipIn.getNextEntry();
                    }
                }
                if (vInputEntry != null) {
                    if (pRes instanceof File) {
                        FileOutputStream vOut = new FileOutputStream((File)pRes);
                        try {
                            StreamUtils.write(vInputEntry, vOut);
                            Object var15_29 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_30 = null;
                            ((OutputStream)vOut).close();
                            throw throwable;
                        }
                        ((OutputStream)vOut).close();
                    } else if (pRes instanceof OutputStream) {
                        StreamUtils.write(vInputEntry, (OutputStream)pRes);
                    }
                }
                Object var17_32 = null;
                if (vZipFile == null) break block27;
            }
            catch (Throwable throwable) {
                Object var17_33 = null;
                if (vZipFile != null) {
                    vZipFile.close();
                    throw throwable;
                }
                if (vZipIn == null) throw throwable;
                vZipIn.close();
                throw throwable;
            }
            vZipFile.close();
            return;
        }
        if (vZipIn == null) return;
        vZipIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void xFillMapEntries(Object pSrc, Object pRes) throws Exception {
        Writer vW = null;
        if (pRes instanceof OutputStream) {
            vW = new OutputStreamWriter((OutputStream)pRes, "UTF-8");
        } else if (pRes instanceof Writer) {
            vW = (Writer)pRes;
        } else if (pRes instanceof File) {
            vW = new OutputStreamWriter((OutputStream)new FileOutputStream((File)pRes), "UTF-8");
        }
        try {
            XmlWriterAppendable vXmlWriter;
            block19: {
                vXmlWriter = new XmlWriterAppendable(vW);
                vXmlWriter.writeHeaderXml("UTF-8");
                vXmlWriter.writeOpenTag(TAG_ZIP);
                Object vSrc = this.xGetSrcFileOrStream(pSrc);
                if (vSrc instanceof File) {
                    File vFile = (File)vSrc;
                    ZipFile vZipFile = new ZipFile(vFile);
                    try {
                        Enumeration<? extends ZipEntry> vEnum = vZipFile.entries();
                        while (vEnum.hasMoreElements()) {
                            ZipEntry vEntry = vEnum.nextElement();
                            vXmlWriter.writeStartTag(TAG_ENTRY);
                            vXmlWriter.writeAttribute(TAG_ENTRY_ATT_NAME, vEntry.getName());
                            if (!vEntry.getName().endsWith("/")) {
                                vXmlWriter.writeAttribute(TAG_ENTRY_ATT_SIZE, Long.toString(vEntry.getSize()));
                            }
                            vXmlWriter.writeEndEmptyTag();
                        }
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        vZipFile.close();
                        throw throwable;
                    }
                    vZipFile.close();
                    {
                        break block19;
                    }
                }
                InputStream vIn = (InputStream)vSrc;
                try {
                    ZipInputStream vZipIn = new ZipInputStream(vIn);
                    ZipEntry vEntry = vZipIn.getNextEntry();
                    while (vEntry != null) {
                        vXmlWriter.writeStartTag(TAG_ENTRY);
                        vXmlWriter.writeAttribute(TAG_ENTRY_ATT_NAME, vEntry.getName());
                        if (!vEntry.getName().endsWith("/")) {
                            vXmlWriter.writeAttribute(TAG_ENTRY_ATT_SIZE, Long.toString(vEntry.getSize()));
                        }
                        vXmlWriter.writeEndEmptyTag();
                        vEntry = vZipIn.getNextEntry();
                    }
                    Object var13_16 = null;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    vIn.close();
                    throw throwable;
                }
                vIn.close();
                {
                }
            }
            vXmlWriter.writeCloseTag(TAG_ZIP);
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (pRes instanceof File) {
                vW.close();
                throw throwable;
            } else {
                vW.flush();
            }
            throw throwable;
        }
        if (pRes instanceof File) {
            vW.close();
            return;
        }
        vW.flush();
    }

    protected Object xGetSrcFileOrStream(Object pSrc) throws Exception {
        String vFilePath;
        Object vSrc = pSrc instanceof ISrcContent ? ((vFilePath = SrcFeatureAlternateUrl.getFilePath((ISrcContent)pSrc)) != null ? new File(vFilePath) : ((ISrcContent)pSrc).newInputStream(false)) : (pSrc instanceof File ? (File)pSrc : (InputStream)pSrc);
        return vSrc;
    }

    public String hGetMimeType(HTransformParams pParams) throws Exception {
        String vMime = pParams.hGetValueParam(PARAM_MIME);
        if (vMime != null) {
            return vMime;
        }
        String vMethod = pParams.hGetValueParam(PARAM_ZIPMETHOD);
        if (vMethod != null) {
            return "application/zip";
        }
        String vPath = pParams.hGetValueParam(PARAM_PATH);
        if (vPath != null) {
            return MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vPath);
        }
        return "text/xml";
    }

    public String hGetFileExtension(HTransformParams pParams) throws Exception {
        String vExt = pParams.hGetValueParam(PARAM_EXT);
        if (vExt != null) {
            return vExt;
        }
        String vMethod = pParams.hGetValueParam(PARAM_ZIPMETHOD);
        if (vMethod != null) {
            return ".zip";
        }
        String vPath = pParams.hGetValueParam(PARAM_PATH);
        if (vPath != null) {
            return MimeMgr.extractLastExtFromUrl(vPath);
        }
        return ".xml";
    }
}

