/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.properties.loaders.xml;

import com.scenari.s.fw.properties.loaders.xml.HInitAppSaxHandlerBase;
import com.scenari.s.fw.properties.loaders.xml.XAloneSaxHandler;
import com.scenari.s.fw.properties.loaders.xml.XLogParamSaxHandler;
import eu.scenari.fw.initapp.ScFramework;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.initapp.SystemProps;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.log.TraceMgr;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HInitAppSaxHandler
extends HInitAppSaxHandlerBase
implements Cloneable {
    public static final String TAG_DECLARETAG = "declareTag";
    public static final String TAG_DECLARETAG_ATT_TAGNAME = "tagName";
    public static final String TAG_DECLARETAG_ATT_PARSER = "classParser";
    public static final String TAG_CLASSLOAD = "classtoload";
    public static final String TAG_CLASSLOAD_ATT_CLASS = "class";
    public static final String TAG_IMPORT = "import";
    public static final String TAG_IMPORT_ATT_HREF = "href";
    public static final String TAG_INIT_APPLICATION = "initapplication";
    public static final String TAG_INIT_APPLICATION_ATT_VERSION = "version";
    public static final String TAG_LOGS = "logs";
    public static final String TAG_TRACE = "trace";
    public static final String TAG_TRACE_ATT_ENABLED = "enabled";
    public static final String TAG_TRACE_ATT_CODE = "code";
    public static final String TAG_PARAM = "param";
    public static final String TAG_PARAM_ATT_KEY = "key";
    public static final String TAG_PARAM_ATT_VALUE = "value";
    public static final String TAG_SYSTEMPROPERTY = "systemProperty";
    public static final String TAG_FRAMEWORK = "framework";
    public static final String TAG_FRAMEWORK_ATT_VERSION = "version";
    protected Map fCustomTags = new HashMap();

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
        boolean vResult;
        block37: {
            Object vClass;
            String vVersion;
            vResult = true;
            if (pLocalName == TAG_FRAMEWORK && (vVersion = pAttributes.getValue("version")) != null) {
                ScFramework.setFrameworkVersion(new ScVersion(vVersion).setZeroToUndefinedNumbers().lock());
            }
            if (pLocalName == TAG_CLASSLOAD) {
                vClass = pAttributes.getValue(TAG_CLASSLOAD_ATT_CLASS);
                if (vClass != null && !((String)vClass).equals("")) {
                    try {
                        Class.forName((String)vClass);
                    }
                    catch (ClassNotFoundException e) {
                        LogMgr.publishException((Throwable)e, "Class '" + (String)vClass + "' defined in the xml init file is missing.", new String[0]);
                    }
                    catch (NoClassDefFoundError e) {
                        LogMgr.publishException((Throwable)e, "Class '" + (String)vClass + "' defined in the xml init file is missing.", new String[0]);
                    }
                }
            } else if (pLocalName == TAG_TRACE) {
                String vCode = pAttributes.getValue(TAG_TRACE_ATT_CODE);
                try {
                    if (vCode == null || vCode.equals("")) break block37;
                    String vEnabled = pAttributes.getValue(TAG_TRACE_ATT_ENABLED);
                    if (vEnabled != null && vEnabled.equals("true")) {
                        TraceMgr.enableTrace(vCode, true);
                        break block37;
                    }
                    TraceMgr.enableTrace(vCode, false);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Trace tag '" + vCode + "' defined in the xml init file failed.", new String[0]);
                }
            } else if (pLocalName == TAG_IMPORT) {
                String vHref = pAttributes.getValue(TAG_IMPORT_ATT_HREF);
                if (vHref != null && !vHref.equals("")) {
                    try {
                        URL vUrl = new URL(this.fUrlSource, vHref);
                        HInitAppSaxHandler vNewHandler = (HInitAppSaxHandler)this.clone();
                        vNewHandler.hSetSource(vUrl);
                        vNewHandler.initApplication();
                    }
                    catch (Exception e) {
                        LogMgr.publishException((Throwable)e, "Import init application '" + vHref + "' failed.", new String[0]);
                    }
                }
            } else if (pLocalName == "properties") {
                try {
                    XAloneSaxHandler vSaxHAndler = new XAloneSaxHandler();
                    vSaxHAndler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Alone properties defined in the xml init file failed.", new String[0]);
                }
            } else if (pLocalName == TAG_LOGS) {
                try {
                    XLogParamSaxHandler vLogSaxHAndler = new XLogParamSaxHandler();
                    vLogSaxHAndler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Log properties defined in the xml init file failed.", new String[0]);
                }
            } else if (pLocalName == TAG_DECLARETAG) {
                String vTagName = pAttributes.getValue(TAG_DECLARETAG_ATT_TAGNAME);
                String vClassName = pAttributes.getValue(TAG_DECLARETAG_ATT_PARSER);
                try {
                    Class<?> vClass2 = Class.forName(vClassName);
                    this.fCustomTags.put(vTagName, vClass2);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec \u00e0 la d\u00e9claration du tag d'initialisation d'application '" + vTagName + "' car la classe associ\u00e9e '" + vClassName + "' est introuvable.", new String[0]);
                }
            } else if (pLocalName == TAG_SYSTEMPROPERTY) {
                String vKey = pAttributes.getValue(TAG_PARAM_ATT_KEY);
                String vValue = pAttributes.getValue(TAG_PARAM_ATT_VALUE);
                try {
                    SystemProps.setProperty(vKey, vValue != null ? vValue : "");
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Echec \u00e0 l'affectation de la propri\u00e9t\u00e9 syst\u00e8me '" + vKey + "'.", new String[0]);
                }
            } else {
                vClass = (Class)this.fCustomTags.get(pLocalName);
                if (vClass != null) {
                    try {
                        HInitAppSaxHandlerBase vSaxHandler = (HInitAppSaxHandlerBase)((Class)vClass).newInstance();
                        vSaxHandler.hSetSource(this.fUrlSource);
                        vSaxHandler.initSaxHandlerForElement(this.fXMLReader, pUri, pLocalName, pQName, pAttributes);
                    }
                    catch (Exception e) {
                        LogMgr.publishException((Throwable)e, "Echec au cours de l'initialisation de l'application lors du tag '" + pLocalName + "'.", new String[0]);
                    }
                } else {
                    vResult = false;
                }
            }
        }
        return vResult;
    }
}

