/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.properties.loaders.xml;

import eu.scenari.fw.initapp.SystemPropsParser;
import eu.scenari.fw.log.IpServerLogs;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XLogParamSaxHandler
extends FragmentSaxHandlerBase {
    public static final String TAG_LOG2FILE = "log2File";
    public static final String TAG_LOG2FILE_ATT_FILE = "file";
    public static final String TAG_LOG2SYSTEMOUT = "log2SystemOut";
    public static final String TAG_LOG2SYSTEMERR = "log2SystemErr";
    public static final String TAG_LOG2SYSTEM_ATT_ENABLED = "enabled";
    public static final String TAG_LOGTEXT2IP = "logText2Ip";
    public static final String TAG_LOG2IP_ATT_IP = "ip";
    public static final String TAG_LOGT2IP_ATT_PORT = "port";

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
        boolean vResult;
        block20: {
            vResult = true;
            if (pLocalName.equals(TAG_LOG2FILE)) {
                String vFileName = pAttributes.getValue(TAG_LOG2FILE_ATT_FILE);
                if (vFileName != null) {
                    try {
                        vFileName = SystemPropsParser.replaceProps(vFileName);
                        File vFile = new File(vFileName).getCanonicalFile();
                        vFile.getParentFile().mkdirs();
                        PrintWriter fPrintWriter = new PrintWriter(new FileWriter(vFile));
                        LogMgr.subscribeAsString(fPrintWriter, false);
                    }
                    catch (Exception e) {
                        LogMgr.publishException((Throwable)e, "Log file " + vFileName + " defined in the xml init file failed.", new String[0]);
                    }
                }
            } else if (pLocalName.equals(TAG_LOG2SYSTEMOUT)) {
                String vEnabled = pAttributes.getValue(TAG_LOG2SYSTEM_ATT_ENABLED);
                if (vEnabled != null && vEnabled.equals("false")) {
                    LogMgr.unsubscribeAsString(System.out, false);
                } else {
                    LogMgr.subscribeAsString(System.out, false);
                }
            } else if (pLocalName.equals(TAG_LOG2SYSTEMERR)) {
                String vEnabled = pAttributes.getValue(TAG_LOG2SYSTEM_ATT_ENABLED);
                if (vEnabled != null && vEnabled.equals("false")) {
                    LogMgr.unsubscribeAsString(System.err, false);
                } else {
                    LogMgr.subscribeAsString(System.err, false);
                }
            } else if (pLocalName.equals(TAG_LOGTEXT2IP)) {
                String vIP = pAttributes.getValue(TAG_LOG2IP_ATT_IP);
                String vPort = pAttributes.getValue(TAG_LOGT2IP_ATT_PORT);
                int vPortInt = 842;
                try {
                    vPortInt = Integer.parseInt(vPort);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (vIP != null) {
                        new IpServerLogs(vIP, vPortInt);
                        break block20;
                    }
                    new IpServerLogs(vPortInt);
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Subscribe log via IP " + vIP + ":" + vPort + " defined in the xml init file failed.", new String[0]);
                }
            } else {
                vResult = false;
            }
        }
        return vResult;
    }
}

