/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.util.xml;

import com.scenari.s.fw.util.xml.HEncodingXml;
import eu.scenari.fw.log.LogMgr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HSaxHandlerToXml
implements ContentHandler,
LexicalHandler {
    protected StringBuilder fStringBuilder = null;
    protected boolean fInCdata = false;
    protected int fOffsetLastElementInDonnee = 0;
    protected List fPrefixMappingList = null;

    public HSaxHandlerToXml() {
    }

    public HSaxHandlerToXml(StringBuilder pBuffer) {
        this.fStringBuilder = pBuffer;
    }

    public final void characters(char[] pChar, int pStart, int pLength) throws SAXException {
        if (this.fInCdata) {
            this.fStringBuilder.append(pChar, pStart, pLength);
        } else {
            try {
                HEncodingXml.hWriteTextValue(this.fStringBuilder, pChar, pStart, pLength);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.fStringBuilder.append("]]>");
        this.fInCdata = false;
    }

    public void endDocument() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        try {
            if (this.fOffsetLastElementInDonnee == this.fStringBuilder.length()) {
                if (this.fStringBuilder.length() > 0) {
                    this.fStringBuilder.setCharAt(this.fStringBuilder.length() - 1, '/');
                    this.fStringBuilder.append('>');
                }
            } else {
                this.fStringBuilder.append("</");
                this.fStringBuilder.append(pQName);
                this.fStringBuilder.append('>');
            }
        }
        catch (Exception e) {
            throw (SAXException)LogMgr.addMessage(new SAXException("Erreur au cours d'un parsing XML d'une fin d'\u00e9l\u00e9ment " + pLocalName), LogMgr.getMessage(e));
        }
    }

    public void endEntity(String name) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public final StringBuilder hGetStringBuilder() {
        return this.fStringBuilder;
    }

    public void hSetStringBuilder(StringBuilder pBuffer) {
        this.fStringBuilder = pBuffer;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.fStringBuilder.append("<![CDATA[");
        this.fInCdata = true;
    }

    public void startDocument() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public final void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
        try {
            this.fStringBuilder.append('<');
            this.fStringBuilder.append(pQName);
            if (this.fPrefixMappingList != null && this.fPrefixMappingList.size() > 0) {
                String[] vPrefix = null;
                for (int i = 0; i < this.fPrefixMappingList.size(); ++i) {
                    vPrefix = (String[])this.fPrefixMappingList.get(i);
                    this.fStringBuilder.append(" xmlns:");
                    this.fStringBuilder.append(vPrefix[0]);
                    this.fStringBuilder.append("=\"");
                    this.fStringBuilder.append(vPrefix[1]);
                    this.fStringBuilder.append('\"');
                }
                this.fPrefixMappingList.clear();
            }
            for (int i = 0; i < pAttributes.getLength(); ++i) {
                this.fStringBuilder.append(' ');
                this.fStringBuilder.append(pAttributes.getQName(i));
                this.fStringBuilder.append("=\"");
                HEncodingXml.hWriteAttributValue(this.fStringBuilder, pAttributes.getValue(i));
                this.fStringBuilder.append('\"');
            }
            this.fStringBuilder.append('>');
            this.fOffsetLastElementInDonnee = this.fStringBuilder.length();
        }
        catch (Exception e) {
            throw (SAXException)LogMgr.addMessage(new SAXException("Erreur au cours d'un parsing XML d'un \u00e9l\u00e9ment " + pLocalName), LogMgr.getMessage(e));
        }
    }

    public void startEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.fPrefixMappingList == null) {
            this.fPrefixMappingList = new ArrayList();
        }
        this.fPrefixMappingList.add(new String[]{prefix, uri});
    }
}

