/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.util.xml;

import org.xml.sax.Attributes;

public class HXmlParserAttributes
implements Attributes {
    protected int fLength = 0;
    protected String[] fValues = null;

    public HXmlParserAttributes(int pDefaultCapacity) {
        this.fValues = new String[pDefaultCapacity * 4];
    }

    public final int getLength() {
        return this.fLength;
    }

    public final String getURI(int pIndex) {
        return this.fValues[pIndex * 4];
    }

    public final String getLocalName(int pIndex) {
        return this.fValues[pIndex * 4 + 1];
    }

    public final String getQName(int pIndex) {
        return this.fValues[pIndex * 4 + 2];
    }

    public final String getType(int pIndex) {
        return "CDATA";
    }

    public final String getValue(int pIndex) {
        return this.fValues[pIndex * 4 + 3];
    }

    public final int getIndex(String pUri, String pLocalName) {
        for (int i = 0; i < this.fLength; i += 4) {
            if (!this.fValues[i + 1].equals(pLocalName) || !this.fValues[i].equals(pUri)) continue;
            return i;
        }
        return -1;
    }

    public final int getIndex(String pQName) {
        int vLen = this.fLength * 4;
        for (int i = 2; i < vLen; i += 4) {
            if (!this.fValues[i].equals(pQName)) continue;
            return i;
        }
        return -1;
    }

    public final String getType(String uri, String localName) {
        return "CDATA";
    }

    public final String getType(String qName) {
        return "CDATA";
    }

    public final String getValue(String pUri, String pLocalName) {
        for (int i = 0; i < this.fLength; i += 4) {
            if (!this.fValues[i + 1].equals(pLocalName) || !this.fValues[i].equals(pUri)) continue;
            return this.fValues[i + 3];
        }
        return null;
    }

    public final String getValue(String pQName) {
        int vLen = this.fLength * 4;
        for (int i = 2; i < vLen; i += 4) {
            if (!this.fValues[i].equals(pQName)) continue;
            return this.fValues[i + 1];
        }
        return null;
    }

    public final void hReset() {
        this.fLength = 0;
    }

    public final void hAdd(String pUri, String pLocalName, String pQName, String pValue) {
        int vOffs = this.fLength * 4;
        if (vOffs + 4 > this.fValues.length) {
            String[] vNew = new String[this.fValues.length * 2];
            System.arraycopy(this.fValues, 0, vNew, 0, this.fValues.length);
            this.fValues = vNew;
        }
        this.fValues[vOffs++] = pUri;
        this.fValues[vOffs++] = pLocalName;
        this.fValues[vOffs++] = pQName;
        this.fValues[vOffs] = pValue;
        ++this.fLength;
    }

    public void setValue(int pIndex, String pValue) {
        if (pValue == null) {
            int vOffset = pIndex * 4;
            int vSize = this.fLength * 4;
            if (vOffset + 4 < vSize) {
                System.arraycopy(this.fValues, vOffset + 4, this.fValues, vOffset, vSize - vOffset - 4);
            }
            this.fValues[vOffset++] = null;
            this.fValues[vOffset++] = null;
            this.fValues[vOffset++] = null;
            this.fValues[vOffset] = null;
            --this.fLength;
        } else {
            this.fValues[pIndex * 4 + 3] = pValue;
        }
    }
}

