/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.util.xsl;

import eu.scenari.fw.log.LogMgr;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class HPoolTemplatesXsl {
    protected String fPoolCode = null;
    protected File fRootUrl = null;
    protected boolean fCheckUpdt = false;
    protected TransformerFactory fFactory = null;
    protected Map fMap = new Hashtable();

    public HPoolTemplatesXsl(String pCode) {
        this.fPoolCode = pCode;
    }

    public Templates hGetTemplate(String pUri) throws Exception {
        long vLast;
        XTemplateHandler vResult = (XTemplateHandler)this.fMap.get(pUri);
        if (vResult == null) {
            vResult = this.xCreateTemplate(pUri);
        } else if (this.fCheckUpdt && (vLast = vResult.fFile.lastModified()) != vResult.fLastUpdates) {
            this.fMap.remove(pUri);
            vResult = this.xCreateTemplate(pUri);
        }
        return vResult != null ? vResult.fTemplate : null;
    }

    public void hSetCheckUpdates(boolean pCheck) {
        this.fCheckUpdt = pCheck;
    }

    public void hSetFactoryXsl(TransformerFactory pFactory) {
        this.fFactory = pFactory;
    }

    public void hSetRootUrl(String pRootUrl) {
        this.fRootUrl = new File(pRootUrl);
    }

    public synchronized XTemplateHandler xCreateTemplate(String pUri) throws Exception {
        XTemplateHandler vResult = (XTemplateHandler)this.fMap.get(pUri);
        if (vResult != null) {
            return vResult;
        }
        File vTemplateFile = this.xGetFile(pUri);
        if (!vTemplateFile.isFile()) {
            throw new Exception("Le fichier '" + vTemplateFile.getAbsolutePath() + "' construit \u00e0 partir de l'Uri '" + pUri + "' dans le pool de template Xsl '" + this.fPoolCode + "' est introuvable.");
        }
        try {
            vResult = new XTemplateHandler();
            vResult.fFile = vTemplateFile;
            vResult.fLastUpdates = vTemplateFile.lastModified();
            if (this.fFactory == null) {
                this.fFactory = TransformerFactory.newInstance();
            }
            StreamSource vSrc = new StreamSource(vTemplateFile);
            vResult.fTemplate = this.fFactory.newTemplates(vSrc);
            this.fMap.put(pUri, vResult);
        }
        catch (Exception e) {
            vResult = null;
            throw (Exception)LogMgr.addMessage((Throwable)e, "La compilation du template Xsl d'Uri '" + pUri + "' issu du fichier '" + vTemplateFile.getAbsolutePath() + "' dans le pool de code '" + this.fPoolCode + "' a \u00e9chou\u00e9.", new String[0]);
        }
        return vResult;
    }

    public File xGetFile(String pUri) {
        return this.fRootUrl != null ? new File(this.fRootUrl, pUri) : new File(pUri);
    }

    class XTemplateHandler {
        protected File fFile = null;
        protected long fLastUpdates = 0L;
        protected Templates fTemplate = null;

        XTemplateHandler() {
        }
    }
}

