/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HIntArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private transient int[] elementData;
    private int size;
    private static final long serialVersionUID = 4650048595246024244L;

    public HIntArrayList() {
        this(10);
    }

    public HIntArrayList(int initialCapacity) {
        this.elementData = new int[initialCapacity];
    }

    public HIntArrayList(Collection c) {
        this.size = c.size();
        this.elementData = new int[this.size * 110 / 100];
        this.addAll(c);
    }

    public void add(int index, Object element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = this.getInt(element);
        ++this.size;
    }

    public boolean add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = this.getInt(o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            this.elementData[index++] = this.getInt(e.next());
        }
        this.size += numNew;
        return numNew != 0;
    }

    public boolean addAll(Collection c) {
        ++this.modCount;
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        Iterator e = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            this.elementData[this.size++] = this.getInt(e.next());
        }
        return numNew != 0;
    }

    public boolean addInt(int pElement) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = pElement;
        return true;
    }

    public void addInt(int pIndex, int pElement) {
        if (pIndex > this.size || pIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + pIndex + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, pIndex, this.elementData, pIndex + 1, this.size - pIndex);
        this.elementData[pIndex] = pElement;
        ++this.size;
    }

    public int insertInOrder(int pElement) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elementData[i] < pElement) continue;
            this.addInt(i, pElement);
            return i;
        }
        this.addInt(pElement);
        return this.size - 1;
    }

    public int insertDistinctInOrder(int pElement) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elementData[i] > pElement) {
                this.addInt(i, pElement);
                return i;
            }
            if (this.elementData[i] != pElement) continue;
            return -1;
        }
        this.addInt(pElement);
        return this.size - 1;
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    public Object clone() {
        try {
            HIntArrayList v = (HIntArrayList)super.clone();
            v.elementData = new int[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public boolean containsInt(int pElement) {
        return this.indexOfInt(pElement) >= 0;
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public Object get(int index) {
        this.RangeCheck(index);
        return new Integer(this.elementData[index]);
    }

    public int getInt(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    private int getInt(Object pObject) {
        return 0;
    }

    public int indexOf(Object elem) {
        int vInt = this.getInt(elem);
        for (int i = 0; i < this.size; ++i) {
            if (vInt != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOfInt(int pElement) {
        for (int i = 0; i < this.size; ++i) {
            if (pElement != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Object elem) {
        int vInt = this.getInt(elem);
        for (int i = this.size - 1; i >= 0; --i) {
            if (vInt != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new int[arrayLength];
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = s.readInt();
        }
    }

    public Object remove(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        int oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
        return new Integer(oldValue);
    }

    public int removeInt(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        int oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
        return oldValue;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = 0;
        }
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        int oldValue = this.elementData[index];
        this.elementData[index] = this.getInt(element);
        return new Integer(oldValue);
    }

    public int setInt(int index, int pElement) {
        this.RangeCheck(index);
        int oldValue = this.elementData[index];
        this.elementData[index] = pElement;
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] result = new Integer[this.size];
        for (int i = 0; i < this.size; ++i) {
            result[i] = new Integer(this.elementData[i]);
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        if (a.getClass().getComponentType() == String.class) {
            for (int i = 0; i < this.size; ++i) {
                a[i] = Integer.toString(this.elementData[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                a[i] = new Integer(this.elementData[i]);
            }
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public int[] toArrayInt() {
        int[] result = new int[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            int[] oldData = this.elementData;
            this.elementData = new int[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeInt(this.elementData[i]);
        }
    }
}

