/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class HLinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private transient Entry header = new Entry(null, null, null);
    private transient Entry headerNotInUse = null;
    private transient int size = 0;
    private static final long serialVersionUID = -8704295655149896549L;

    public HLinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    public HLinkedList(Collection c) {
        this();
        this.addAll(c);
    }

    public void add(int index, Object element) {
        this.addBefore(element, index == this.size ? this.header : this.entry(index));
    }

    public boolean add(Object o) {
        this.addBefore(o, this.header);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int numNew = c.size();
        if (numNew == 0) {
            return false;
        }
        ++this.modCount;
        Entry successor = index == this.size ? this.header : this.entry(index);
        Entry predecessor = successor.previous;
        Iterator it = c.iterator();
        for (int i = 0; i < numNew; ++i) {
            Entry e;
            predecessor.next = e = this.getFreeEntry(it.next(), successor, predecessor);
            predecessor = e;
        }
        successor.previous = predecessor;
        this.size += numNew;
        return true;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    private Entry addBefore(Object o, Entry e) {
        Entry newEntry;
        newEntry.previous.next = newEntry = this.getFreeEntry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    public void addFirst(Object o) {
        this.addBefore(o, this.header.next);
    }

    public void addLast(Object o) {
        this.addBefore(o, this.header);
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public Object clone() {
        return new LinkedList(this);
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    private Entry entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Entry e = this.header;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.previous;
            }
        }
        return e;
    }

    public Object get(int index) {
        return this.entry((int)index).element;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    private Entry getFreeEntry(Object o, Entry eNext, Entry ePrevious) {
        Entry newEntry;
        if (this.headerNotInUse != null) {
            newEntry = this.headerNotInUse;
            if (this.headerNotInUse.next == this.headerNotInUse) {
                this.headerNotInUse = null;
            } else {
                this.headerNotInUse.previous.next = this.headerNotInUse.next;
                this.headerNotInUse.next.previous = this.headerNotInUse.previous;
                this.headerNotInUse = this.headerNotInUse.next;
            }
            newEntry.element = o;
            newEntry.next = eNext;
            newEntry.previous = ePrevious;
        } else {
            newEntry = new Entry(o, eNext, ePrevious);
        }
        return newEntry;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return index;
                }
                ++index;
                e = e.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size;
        if (o == null) {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (e.element == null) {
                    return index;
                }
                e = e.previous;
            }
        } else {
            Entry e = this.header.previous;
            while (e != this.header) {
                --index;
                if (o.equals(e.element)) {
                    return index;
                }
                e = e.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int vSize = s.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        for (int i = 0; i < vSize; ++i) {
            this.add(s.readObject());
        }
    }

    public Object remove(int index) {
        Entry e = this.entry(index);
        this.remove(e);
        return e.element;
    }

    private void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
        ++this.modCount;
        e.element = null;
        if (this.headerNotInUse == null) {
            e.previous = e;
            e.next = e;
            this.headerNotInUse = e;
        } else {
            e.next = this.headerNotInUse.next;
            e.previous = this.headerNotInUse;
            this.headerNotInUse.next.previous = e;
            this.headerNotInUse.next = e;
        }
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object removeFirst() {
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    public Object set(int index, Object element) {
        Entry e = this.entry(index);
        Object oldVal = e.element;
        e.element = element;
        return oldVal;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            a[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Entry e = this.header.next;
        while (e != this.header) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object pElement, Entry pNext, Entry pPrevious) {
            this.element = pElement;
            this.next = pNext;
            this.previous = pPrevious;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.lastReturned = HLinkedList.this.header;
            this.expectedModCount = HLinkedList.this.modCount;
            if (index < 0 || index > HLinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + HLinkedList.this.size);
            }
            if (index < HLinkedList.this.size / 2) {
                this.next = ((HLinkedList)HLinkedList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = HLinkedList.this.header;
                this.nextIndex = HLinkedList.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        public boolean hasNext() {
            return this.nextIndex != HLinkedList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == HLinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            HLinkedList.this.remove(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = HLinkedList.this.header;
            ++this.expectedModCount;
        }

        public void set(Object o) {
            if (this.lastReturned == HLinkedList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = o;
        }

        public void add(Object o) {
            this.checkForComodification();
            this.lastReturned = HLinkedList.this.header;
            HLinkedList.this.addBefore(o, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (HLinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

