/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.s.fw.utils;

import com.scenari.s.fw.utils.HParamsQueryString;
import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.BitSet;

public class HUrl {
    public static final String URLENCODING_ISO88591 = "iso-8859-1";
    public static final String URLENCODING_UTF8 = "utf-8";
    protected String fUrl = null;
    protected HParamsQueryString fParams = null;
    static BitSet sDontNeedEncodingUrl;
    static final int caseDiff = 32;
    static String dfltEncName;
    static BitSet sDontNeedEncodingParam;

    public HUrl() {
    }

    public HUrl(String pUrlAvecParams) throws Exception {
        this.hInit(pUrlAvecParams);
    }

    public boolean equals(Object pObject) {
        if (pObject != null && pObject instanceof HUrl) {
            HUrl vObj = (HUrl)pObject;
            if (this.fUrl != null ? !this.fUrl.equals(vObj.fUrl) : vObj.fUrl != null) {
                return false;
            }
            if (this.fParams != null) {
                return this.fParams.equals(vObj.fParams);
            }
            return vObj.fParams == null;
        }
        return false;
    }

    public int hCountParams() {
        return this.fParams != null ? this.fParams.hCountParams() : 0;
    }

    public HParamsQueryString.ParamsIterator hGetParamNames() {
        return this.fParams != null ? this.fParams.hGetParamNames() : null;
    }

    public String hGetUrlWithoutParams() {
        return this.fUrl;
    }

    public String hGetValue(String pKey) {
        return this.fParams != null ? this.fParams.hGetValue(pKey) : null;
    }

    public String[] hGetValues(String pKey) {
        return this.fParams != null ? this.fParams.hGetValues(pKey) : null;
    }

    public void hInit(String pUrlAvecParams) throws Exception {
        if (pUrlAvecParams != null) {
            int vOffs = pUrlAvecParams.indexOf(63);
            if (vOffs >= 0) {
                this.fUrl = pUrlAvecParams.substring(0, vOffs);
                if (vOffs < this.fUrl.length() + 1) {
                    this.fParams = new HParamsQueryString();
                    this.fParams.hInit(pUrlAvecParams.substring(vOffs + 1));
                }
            } else {
                this.fUrl = pUrlAvecParams;
            }
        } else {
            this.fUrl = "";
        }
    }

    public void hInit(String pUrlSansParams, String pParams) throws Exception {
        this.fUrl = pUrlSansParams == null ? "" : pUrlSansParams;
        if (pParams != null && !pParams.equals("")) {
            this.fParams = new HParamsQueryString();
            this.fParams.hInit(pParams);
        }
    }

    public static String hNormalize(String pPath) {
        int vIndex;
        String vResult = pPath;
        if (pPath == null) {
            return null;
        }
        if (vResult.indexOf(92) >= 0) {
            vResult = vResult.replace('\\', '/');
        }
        if (!vResult.startsWith("/")) {
            vResult = "/".concat(vResult);
        }
        if (vResult.equals("/.")) {
            return "/";
        }
        while ((vIndex = vResult.indexOf("//")) >= 0) {
            vResult = vResult.substring(0, vIndex).concat(vResult.substring(vIndex + 1));
        }
        while ((vIndex = vResult.indexOf("/./")) >= 0) {
            vResult = vResult.substring(0, vIndex).concat(vResult.substring(vIndex + 2));
        }
        while ((vIndex = vResult.indexOf("/../")) >= 0) {
            if (vIndex == 0) {
                return null;
            }
            int vIndex2 = vResult.lastIndexOf(47, vIndex - 1);
            vResult = vResult.substring(0, vIndex2).concat(vResult.substring(vIndex + 3));
        }
        return vResult;
    }

    public static String hEncode(CharSequence s, String enc) throws UnsupportedEncodingException {
        return HUrl.xEncode(s, enc, sDontNeedEncodingUrl);
    }

    public static String hEncodeParam(CharSequence s, String enc) throws UnsupportedEncodingException {
        return HUrl.xEncode(s, enc, sDontNeedEncodingParam);
    }

    public static String xEncode(CharSequence s, String enc, BitSet pDontNeedToEncode) throws UnsupportedEncodingException {
        if (enc == null) {
            throw new NullPointerException("charsetName");
        }
        StringBuffer out = null;
        CharArrayWriter charArrayWriter = null;
        Charset charset = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (pDontNeedToEncode.get(c)) {
                if (out != null) {
                    out.append(c);
                }
                ++i;
                continue;
            }
            if (out == null) {
                try {
                    charset = Charset.forName(enc);
                }
                catch (IllegalCharsetNameException e) {
                    throw new UnsupportedEncodingException(enc);
                }
                catch (UnsupportedCharsetException e) {
                    throw new UnsupportedEncodingException(enc);
                }
                out = new StringBuffer(s.length() + 32);
                if (i > 0) {
                    out.append(s, 0, i);
                }
                charArrayWriter = new CharArrayWriter();
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !pDontNeedToEncode.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(charset.name());
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
        }
        return out != null ? out.toString() : ((Object)s).toString();
    }

    public static String decodeURI(String pUri, String pEncoding) throws Exception {
        if (pUri.indexOf(37) < 0 && pUri.indexOf(43) < 0) {
            return pUri;
        }
        return HUrl.decodeURI(pUri, 0, pUri.length(), pEncoding, new StringBuilder());
    }

    public static int decodeExa(char pChar1, char pChar2) {
        int v2;
        int v1 = pChar1 - 48;
        if (v1 > 9 && (v1 -= 7) > 15) {
            v1 -= 32;
        }
        if ((v2 = pChar2 - 48) > 9 && (v2 -= 7) > 15) {
            v2 -= 32;
        }
        return (v1 << 4) + v2;
    }

    public static String decodeURI(CharSequence pUri, int pOffset, int pOffsetEnd, String pEncoding) throws Exception {
        return HUrl.decodeURI(pUri, pOffset, pOffsetEnd, pEncoding, new StringBuilder(pOffsetEnd - pOffset));
    }

    public static String decodeURI(CharSequence pUri, int pOffset, int pOffsetEnd, String pEncoding, StringBuilder pBuf) throws Exception {
        pBuf.setLength(0);
        int vEnc = 0;
        if (pEncoding == null || pEncoding == URLENCODING_UTF8) {
            vEnc = 1;
        } else if (pEncoding == URLENCODING_ISO88591) {
            vEnc = 2;
        }
        if (vEnc == 0) {
            if (pEncoding.equalsIgnoreCase(URLENCODING_UTF8)) {
                vEnc = 1;
            } else if (pEncoding.equalsIgnoreCase(URLENCODING_ISO88591)) {
                vEnc = 2;
            } else {
                return URLDecoder.decode(((Object)pUri.subSequence(pOffset, pOffsetEnd)).toString(), pEncoding);
            }
        }
        int i = pOffset;
        while (i < pOffsetEnd) {
            char vChar = pUri.charAt(i);
            if (vChar == '%' && pOffsetEnd >= i + 3) {
                int n = ++i;
                int n2 = ++i;
                ++i;
                int v1 = HUrl.decodeExa(pUri.charAt(n), pUri.charAt(n2));
                if (vEnc == 2) {
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 < 128) {
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 < 224) {
                    if (pOffsetEnd < i + 3 || pUri.charAt(i) != '%') continue;
                    int n3 = ++i;
                    int n4 = ++i;
                    ++i;
                    v1 = (v1 - 192 << 6) + HUrl.decodeExa(pUri.charAt(n3), pUri.charAt(n4)) - 128;
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 < 240) {
                    if (pOffsetEnd < i + 6 || pUri.charAt(i) != '%' || pUri.charAt(i + 3) != '%') continue;
                    int n5 = ++i;
                    int n6 = ++i;
                    ++i;
                    v1 = (v1 - 224 << 6) + HUrl.decodeExa(pUri.charAt(n5), pUri.charAt(n6)) - 128;
                    int n7 = ++i;
                    int n8 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n7), pUri.charAt(n8)) - 128;
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 < 248) {
                    if (pOffsetEnd < i + 9 || pUri.charAt(i) != '%' || pUri.charAt(i + 3) != '%' || pUri.charAt(i + 6) != '%') continue;
                    int n9 = ++i;
                    int n10 = ++i;
                    ++i;
                    v1 = (v1 - 240 << 6) + HUrl.decodeExa(pUri.charAt(n9), pUri.charAt(n10)) - 128;
                    int n11 = ++i;
                    int n12 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n11), pUri.charAt(n12)) - 128;
                    int n13 = ++i;
                    int n14 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n13), pUri.charAt(n14)) - 128;
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 < 252) {
                    if (pOffsetEnd < i + 12 || pUri.charAt(i) != '%' || pUri.charAt(i + 3) != '%' || pUri.charAt(i + 6) != '%' || pUri.charAt(i + 9) != '%') continue;
                    int n15 = ++i;
                    int n16 = ++i;
                    ++i;
                    v1 = (v1 - 248 << 6) + HUrl.decodeExa(pUri.charAt(n15), pUri.charAt(n16)) - 128;
                    int n17 = ++i;
                    int n18 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n17), pUri.charAt(n18)) - 128;
                    int n19 = ++i;
                    int n20 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n19), pUri.charAt(n20)) - 128;
                    int n21 = ++i;
                    int n22 = ++i;
                    ++i;
                    v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n21), pUri.charAt(n22)) - 128;
                    pBuf.append((char)v1);
                    continue;
                }
                if (v1 >= 254 || pOffsetEnd < i + 15 || pUri.charAt(i) != '%' || pUri.charAt(i + 3) != '%' || pUri.charAt(i + 6) != '%' || pUri.charAt(i + 9) != '%' || pUri.charAt(i + 12) != '%') continue;
                int n23 = ++i;
                int n24 = ++i;
                ++i;
                v1 = (v1 - 252 << 6) + HUrl.decodeExa(pUri.charAt(n23), pUri.charAt(n24)) - 128;
                int n25 = ++i;
                int n26 = ++i;
                ++i;
                v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n25), pUri.charAt(n26)) - 128;
                int n27 = ++i;
                int n28 = ++i;
                ++i;
                v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n27), pUri.charAt(n28)) - 128;
                int n29 = ++i;
                int n30 = ++i;
                ++i;
                v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n29), pUri.charAt(n30)) - 128;
                int n31 = ++i;
                int n32 = ++i;
                ++i;
                v1 = (v1 << 6) + HUrl.decodeExa(pUri.charAt(n31), pUri.charAt(n32)) - 128;
                pBuf.append((char)v1);
                continue;
            }
            if (vChar == '+') {
                pBuf.append(' ');
                ++i;
                continue;
            }
            pBuf.append(vChar);
            ++i;
        }
        return pBuf.toString();
    }

    static {
        int i;
        dfltEncName = null;
        sDontNeedEncodingUrl = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            sDontNeedEncodingUrl.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            sDontNeedEncodingUrl.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            sDontNeedEncodingUrl.set(i);
        }
        sDontNeedEncodingUrl.set(45);
        sDontNeedEncodingUrl.set(95);
        sDontNeedEncodingUrl.set(46);
        sDontNeedEncodingUrl.set(33);
        sDontNeedEncodingUrl.set(126);
        sDontNeedEncodingUrl.set(42);
        sDontNeedEncodingUrl.set(39);
        sDontNeedEncodingUrl.set(40);
        sDontNeedEncodingUrl.set(41);
        sDontNeedEncodingUrl.set(47);
        sDontNeedEncodingUrl.set(58);
        sDontNeedEncodingParam = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            sDontNeedEncodingParam.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            sDontNeedEncodingParam.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            sDontNeedEncodingParam.set(i);
        }
        sDontNeedEncodingParam.set(45);
        sDontNeedEncodingParam.set(95);
        sDontNeedEncodingParam.set(46);
        sDontNeedEncodingParam.set(33);
        sDontNeedEncodingParam.set(126);
        sDontNeedEncodingParam.set(42);
        sDontNeedEncodingParam.set(39);
        sDontNeedEncodingParam.set(40);
        sDontNeedEncodingParam.set(41);
    }
}

