/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.serializer.simple;

import com.scenari.serializer.ISerializerHandler;
import com.scenari.serializer.simple.IXmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XmlWriter2ContentHandler
implements IXmlWriter {
    protected ContentHandler fContentHanlder;
    protected LexicalHandler fLexicalHanlder;
    protected ISerializerHandler fSerializer;
    protected AttributesImpl fAtts = new AttributesImpl();
    protected ArrayList<String> fStackTags = new ArrayList();

    public XmlWriter2ContentHandler(ContentHandler pHandler) {
        this.fContentHanlder = pHandler;
        this.fSerializer = pHandler instanceof ISerializerHandler ? (ISerializerHandler)pHandler : null;
        this.fLexicalHanlder = pHandler instanceof LexicalHandler ? (LexicalHandler)((Object)pHandler) : null;
    }

    public void writeAttribute(String pAttName, String pContent) throws Exception {
        this.fAtts.addAttribute("", pAttName, pAttName, null, pContent);
    }

    public void writeCloseTag(String pTagName) throws Exception {
        this.fStackTags.remove(this.fStackTags.size() - 1);
        this.fContentHanlder.endElement("", pTagName, pTagName);
    }

    public void writeComment(CharSequence pText) throws Exception {
        if (this.fSerializer == null) {
            throw new Exception("TODO");
        }
        this.fSerializer.comment(pText);
    }

    public void writeComment(char[] pCh, int pStart, int pLength) throws Exception {
        if (this.fSerializer != null) {
            this.fSerializer.comment(pCh, pStart, pLength);
        }
    }

    public void writeEmptyTag(String pTagName) throws Exception {
        this.fAtts.clear();
        this.fContentHanlder.startElement("", pTagName, pTagName, this.fAtts);
        this.fContentHanlder.endElement("", pTagName, pTagName);
    }

    public void writeEndEmptyTag() throws Exception {
        String vTagName = this.fStackTags.remove(this.fStackTags.size() - 1);
        this.fContentHanlder.startElement("", vTagName, vTagName, this.fAtts);
        this.fContentHanlder.endElement("", vTagName, vTagName);
    }

    public void writeEndOpenTag() throws Exception {
        String vTagName = this.fStackTags.get(this.fStackTags.size() - 1);
        this.fContentHanlder.startElement("", vTagName, vTagName, this.fAtts);
    }

    public void writeHeaderXml(String pEncoding) throws Exception {
    }

    public void writeOpenTag(String pTagName) throws Exception {
        this.fStackTags.add(pTagName);
        this.fAtts.clear();
        this.fContentHanlder.startElement("", pTagName, pTagName, this.fAtts);
    }

    public void writeStartTag(String pTagName) throws Exception {
        this.fStackTags.add(pTagName);
        this.fAtts.clear();
    }

    public void writeTag(String pTagName, String pContent) throws Exception {
        this.fAtts.clear();
        this.fContentHanlder.startElement("", pTagName, pTagName, this.fAtts);
        this.writeText(pContent);
        this.fContentHanlder.endElement("", pTagName, pTagName);
    }

    public void writeText(CharSequence pText) throws Exception {
        if (this.fSerializer == null) {
            throw new Exception("TODO");
        }
        this.fSerializer.characters(pText);
    }

    public void writeText(char[] pCh, int pStart, int pLength) throws Exception {
        this.fContentHanlder.characters(pCh, pStart, pLength);
    }

    public void writeXmlFragment(CharSequence pFragment) throws Exception {
        this.fContentHanlder.processingInstruction("javax.xml.transform.disable-output-escaping", "");
        if (this.fSerializer == null) {
            throw new Exception("TODO");
        }
        this.fSerializer.characters(pFragment);
        this.fContentHanlder.processingInstruction("javax.xml.transform.enable-output-escaping", "");
    }

    public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
        this.fContentHanlder.characters(pCh, pStart, pLength);
    }

    public void endDocument() throws SAXException {
        this.fContentHanlder.endDocument();
    }

    public void endElement(String pUri, String pLocalName, String pName) throws SAXException {
        this.fContentHanlder.endElement(pUri, pLocalName, pName);
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        this.fContentHanlder.endPrefixMapping(pPrefix);
    }

    public void ignorableWhitespace(char[] pCh, int pStart, int pLength) throws SAXException {
        this.fContentHanlder.ignorableWhitespace(pCh, pStart, pLength);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        this.fContentHanlder.processingInstruction(pTarget, pData);
    }

    public void setDocumentLocator(Locator pLocator) {
        this.fContentHanlder.setDocumentLocator(pLocator);
    }

    public void skippedEntity(String pName) throws SAXException {
        this.fContentHanlder.skippedEntity(pName);
    }

    public void startDocument() throws SAXException {
        this.fContentHanlder.startDocument();
    }

    public void startElement(String pUri, String pLocalName, String pName, Attributes pAtts) throws SAXException {
        this.fContentHanlder.startElement(pUri, pLocalName, pName, pAtts);
    }

    public void startPrefixMapping(String pPrefix, String pUri) throws SAXException {
        this.fContentHanlder.startPrefixMapping(pPrefix, pUri);
    }

    public void characters(CharSequence pText) throws SAXException {
        if (this.fSerializer == null) {
            throw new SAXException("TODO");
        }
        this.fSerializer.characters(pText);
    }

    public void comment(char[] pCh, int pStart, int pLength) throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fLexicalHanlder.comment(pCh, pStart, pLength);
        }
    }

    public void comment(CharSequence pText) throws SAXException {
        if (this.fSerializer == null) {
            throw new SAXException("TODO");
        }
        this.fSerializer.comment(pText);
    }

    public void endCDATA() throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fLexicalHanlder.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fLexicalHanlder.endDTD();
        }
    }

    public void endEntity(String pName) throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fLexicalHanlder.endEntity(pName);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fSerializer.startCDATA();
        }
    }

    public void startDTD(String pName, String pPublicId, String pSystemId) throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fSerializer.startDTD(pName, pPublicId, pSystemId);
        }
    }

    public void startEntity(String pName) throws SAXException {
        if (this.fLexicalHanlder != null) {
            this.fSerializer.startEntity(pName);
        }
    }

    public void close() throws IOException {
    }
}

