/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.serializer.simple;

import com.scenari.serializer.simple.IXmlWriter;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlWriterAppendable
implements IXmlWriter {
    protected Appendable fBuf = null;
    protected List<Boolean> fSaxTagsOpened = null;

    public XmlWriterAppendable(Appendable pBuf) {
        this.fBuf = pBuf;
    }

    public void writeHeaderXml(String pEncoding) throws Exception {
        if (pEncoding == null) {
            this.fBuf.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        } else {
            this.fBuf.append("<?xml version=\"1.0\" encoding=\"");
            this.fBuf.append(pEncoding);
            this.fBuf.append("\" ?>\n");
        }
    }

    public void writeAttribute(String pAttName, String pContent) throws Exception {
        if (pAttName != null && pContent != null) {
            this.fBuf.append(' ');
            this.fBuf.append(pAttName);
            this.fBuf.append("=\"");
            this.xWriteText(pContent);
            this.fBuf.append('\"');
        }
    }

    public void writeStartTag(String pNomTag) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteStartTag(pNomTag);
    }

    protected void xWriteStartTag(String pNomTag) throws Exception {
        this.fBuf.append('<');
        this.fBuf.append(pNomTag);
    }

    public void writeEndOpenTag() throws Exception {
        this.fBuf.append('>');
    }

    public void writeEndEmptyTag() throws Exception {
        this.fBuf.append("/>");
    }

    public void writeTag(String pNomTag, String pContenu) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteTag(pNomTag, pContenu);
    }

    protected void xWriteTag(String pNomTag, String pContenu) throws Exception {
        this.fBuf.append('<');
        this.fBuf.append(pNomTag);
        this.fBuf.append('>');
        if (pContenu != null) {
            this.xWriteText(pContenu);
        }
        this.fBuf.append("</");
        this.fBuf.append(pNomTag);
        this.fBuf.append('>');
    }

    public void writeEmptyTag(String pNomTag) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.fBuf.append('<');
        this.fBuf.append(pNomTag);
        this.fBuf.append("/>");
    }

    public void writeCloseTag(String pNomTag) throws Exception {
        this.fBuf.append("</");
        this.fBuf.append(pNomTag);
        this.fBuf.append('>');
    }

    public void writeOpenTag(String pNomTag) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.fBuf.append('<');
        this.fBuf.append(pNomTag);
        this.fBuf.append('>');
    }

    public void writeText(CharSequence pText) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteText(pText);
    }

    protected void xWriteText(CharSequence pText) throws Exception {
        if (pText == null) {
            return;
        }
        block6: for (int i = 0; i < pText.length(); ++i) {
            char vCar = pText.charAt(i);
            switch (vCar) {
                case '<': {
                    this.fBuf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.fBuf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    this.fBuf.append("&quot;");
                    continue block6;
                }
                case '&': {
                    this.fBuf.append("&amp;");
                    continue block6;
                }
                default: {
                    this.fBuf.append(vCar);
                }
            }
        }
    }

    public void writeText(char[] pCh, int pStart, int pLength) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteText(pCh, pStart, pLength);
    }

    protected void xWriteText(char[] pCh, int pStart, int pLength) throws Exception {
        if (pCh == null || pLength <= 0 || pStart >= pCh.length) {
            return;
        }
        int vEnd = Math.min(pCh.length, pStart + pLength);
        block6: for (int i = pStart; i < vEnd; ++i) {
            char vCar = pCh[i];
            switch (vCar) {
                case '<': {
                    this.fBuf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    this.fBuf.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    this.fBuf.append("&quot;");
                    continue block6;
                }
                case '&': {
                    this.fBuf.append("&amp;");
                    continue block6;
                }
                default: {
                    this.fBuf.append(vCar);
                }
            }
        }
    }

    public void writeComment(char[] pCh, int pStart, int pLength) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteComment(pCh, pStart, pLength);
    }

    protected void xWriteComment(char[] pCh, int pStart, int pLength) throws Exception {
        this.fBuf.append("<!--");
        if (pCh == null || pLength <= 0 || pStart >= pCh.length) {
            return;
        }
        int vEnd = Math.min(pCh.length, pStart + pLength);
        for (int i = pStart; i < vEnd; ++i) {
            char vCar = pCh[i];
            this.fBuf.append(vCar);
        }
        this.fBuf.append("-->");
    }

    public void writeComment(CharSequence pComment) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.xWriteComment(pComment);
    }

    protected void xWriteComment(CharSequence pComment) throws Exception {
        this.fBuf.append("<!--");
        this.fBuf.append(pComment);
        this.fBuf.append("-->");
    }

    public void writeXmlFragment(CharSequence pFragment) throws Exception {
        this.xXmlWriterCheckEndOpenTag();
        this.fBuf.append(pFragment);
    }

    public void close() throws IOException {
        if (this.fBuf instanceof Closeable) {
            ((Closeable)((Object)this.fBuf)).close();
        }
    }

    public void characters(char[] pCh, int pStart, int pLength) throws SAXException {
        try {
            this.xSaxCheckEndOpenTag();
            this.xWriteText(pCh, pStart, pLength);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void characters(CharSequence pText) throws SAXException {
        try {
            this.xSaxCheckEndOpenTag();
            this.xWriteText(pText);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void comment(CharSequence pText) throws SAXException {
        try {
            this.xSaxCheckEndOpenTag();
            this.xWriteComment(pText);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void comment(char[] pCh, int pStart, int pLength) throws SAXException {
        try {
            this.xSaxCheckEndOpenTag();
            this.xWriteComment(pCh, pStart, pLength);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String pUri, String pLocalName, String pName) throws SAXException {
        try {
            int vLastIdx = this.fSaxTagsOpened.size() - 1;
            if (this.fSaxTagsOpened.get(vLastIdx) == Boolean.FALSE) {
                this.writeEndEmptyTag();
            } else {
                this.writeCloseTag(pName);
            }
            this.fSaxTagsOpened.remove(vLastIdx);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] pCh, int pStart, int pLength) throws SAXException {
        this.characters(pCh, pStart, pLength);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
    }

    public void setDocumentLocator(Locator pLocator) {
    }

    public void skippedEntity(String pName) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String pUri, String pLocalName, String pName, Attributes pAtts) throws SAXException {
        try {
            this.xSaxCheckEndOpenTag();
            this.fSaxTagsOpened.add(Boolean.FALSE);
            this.xWriteStartTag(pName);
            for (int i = 0; i < pAtts.getLength(); ++i) {
                this.writeAttribute(pAtts.getQName(i), pAtts.getValue(i));
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    protected void xSaxCheckEndOpenTag() throws Exception {
        int vLastIdx;
        if (this.fSaxTagsOpened == null) {
            this.fSaxTagsOpened = new ArrayList<Boolean>(24);
        }
        if ((vLastIdx = this.fSaxTagsOpened.size() - 1) >= 0 && this.fSaxTagsOpened.get(vLastIdx) == Boolean.FALSE) {
            this.fSaxTagsOpened.set(vLastIdx, Boolean.TRUE);
            this.writeEndOpenTag();
        }
    }

    protected void xXmlWriterCheckEndOpenTag() throws Exception {
        if (this.fSaxTagsOpened == null) {
            return;
        }
        int vLastIdx = this.fSaxTagsOpened.size() - 1;
        if (vLastIdx >= 0 && this.fSaxTagsOpened.get(vLastIdx) == Boolean.FALSE) {
            this.fSaxTagsOpened.set(vLastIdx, Boolean.TRUE);
            this.writeEndOpenTag();
        }
    }

    public void startPrefixMapping(String pPrefix, String pUri) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String pName) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String pName, String pPublicId, String pSystemId) throws SAXException {
    }

    public void startEntity(String pName) throws SAXException {
    }
}

