/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.copymove;

import com.scenari.src.ISrcNode;
import com.scenari.src.feature.copymove.ICopyMoveAspect;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import eu.scenari.fw.log.LogMgr;
import java.util.ArrayList;

public class SrcFeatureCopyMove {
    public static void copy(ISrcNode pFrom, ISrcNode pTarget) throws Exception {
        ICopyMoveAspect vAspect = pTarget.getAspect(ICopyMoveAspect.TYPE);
        if (vAspect != null) {
            vAspect.copyFrom(pFrom);
        } else {
            SrcFeatureCopyMove.defaultCopy(pFrom, pTarget);
        }
    }

    public static void move(ISrcNode pFrom, ISrcNode pTarget) throws Exception {
        ICopyMoveAspect vAspect = pTarget.getAspect(ICopyMoveAspect.TYPE);
        if (vAspect != null) {
            vAspect.moveFrom(pFrom);
        } else {
            SrcFeatureCopyMove.defaultMove(pFrom, pTarget);
        }
    }

    public static void defaultCopy(ISrcNode pFrom, ISrcNode pTarget) throws Exception {
        int vSrcStatus = pFrom.getContentStatus();
        if (vSrcStatus == 2) {
            if (pTarget.getContentStatus() != -1 && !pTarget.removeSrc()) {
                throw LogMgr.newException("Echec lors de la suppression de la destination de la copie : " + pTarget.getSrcUri(), new String[0]);
            }
            if (!pTarget.createAsFolder()) {
                throw LogMgr.newException("Echec lors de la cr\u00e9ation de la destination de la copie : " + pTarget.getSrcUri(), new String[0]);
            }
            ArrayList<ISrcNode> vList = new ArrayList<ISrcNode>();
            pFrom.listChildrenNodes(vList);
            for (int i = 0; i < vList.size(); ++i) {
                ISrcNode vSrc = (ISrcNode)vList.get(i);
                ISrcNode vDst = pTarget.findNodeChild(vSrc.getSrcName());
                SrcFeatureCopyMove.copy(vSrc, vDst);
            }
        } else if (vSrcStatus == 1) {
            if (pTarget.getContentStatus() != -1 && !pTarget.removeSrc()) {
                throw LogMgr.newException("Echec lors de la suppression de la destination de la copie : " + pTarget.getSrcUri(), new String[0]);
            }
            SrcFeatureStreams.writeFrom(pTarget, pFrom.newInputStream(false));
        }
    }

    public static void defaultMove(ISrcNode pFrom, ISrcNode pTarget) throws Exception {
        if (pTarget.getContentStatus() != -1) {
            throw LogMgr.newException("Target move '" + pTarget.getSrcUri() + "' is not empty. '" + pFrom.getSrcUri() + "' can't be moved.", new String[0]);
        }
        int vSrcStatus = pFrom.getContentStatus();
        if (vSrcStatus == 1) {
            try {
                SrcFeatureCopyMove.defaultCopy(pFrom, pTarget);
            }
            catch (Exception e) {
                try {
                    pTarget.removeSrc();
                }
                catch (Exception ee) {
                    LogMgr.publishException(e);
                }
                throw e;
            }
            pFrom.removeSrc();
        } else if (vSrcStatus == 2) {
            if (!pTarget.createAsFolder()) {
                throw LogMgr.newException("Echec lors de la cr\u00e9ation de la destination de la copie : " + pTarget.getSrcUri(), new String[0]);
            }
            ArrayList<ISrcNode> vList = new ArrayList<ISrcNode>();
            pFrom.listChildrenNodes(vList);
            try {
                for (int i = 0; i < vList.size(); ++i) {
                    ISrcNode vSrc = (ISrcNode)vList.get(i);
                    ISrcNode vDst = pTarget.findNodeChild(vSrc.getSrcName());
                    SrcFeatureCopyMove.move(vSrc, vDst);
                }
            }
            catch (Exception e) {
                try {
                    pTarget.removeSrc();
                }
                catch (Exception ee) {
                    LogMgr.publishException(e);
                }
                throw e;
            }
            pFrom.removeSrc();
        }
    }
}

