/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.fields;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.ids.IIdAspect;
import com.scenari.src.feature.rights.SrcFeatureRights;

public class SrcFeatureFields {
    public static final String DATAKEY_URI = FieldsCollectorBuilder.declareDataKey("srcUri");
    public static final String DATAKEY_ID = FieldsCollectorBuilder.declareDataKey("srcId");
    public static final String DATAKEY_LASTMODIF = FieldsCollectorBuilder.declareDataKey("srcDt");
    public static final String DATAKEY_TREELASTMODIF = FieldsCollectorBuilder.declareDataKey("srcTreeDt");
    public static final String DATAKEY_CONTENTSIZE = FieldsCollectorBuilder.declareDataKey("srcSi");
    public static final String DATAKEY_CONTENTTYPE = FieldsCollectorBuilder.declareDataKey("srcTy");
    public static final String DATAKEY_CONTENTSTATUS = FieldsCollectorBuilder.declareDataKey("srcSt");
    public static final String DATAKEY_RIGHTS = FieldsCollectorBuilder.declareDataKey("srcRi");
    public static final String DATAKEY_MODIFICATIONUSER = FieldsCollectorBuilder.declareDataKey("srcUser");
    public static final String DATAKEYALIAS_BASIS = FieldsCollectorBuilder.declareAlias("basis", DATAKEY_URI, DATAKEY_ID, DATAKEY_CONTENTSTATUS, DATAKEY_LASTMODIF, DATAKEY_CONTENTSIZE);

    public static void fillFields(ISrcContent pSrcContent, IFieldsCollector pFieldsToCollect) throws Exception {
        IFieldsProviderAspect vFieldsProvider = pSrcContent.getAspect(IFieldsProviderAspect.TYPE);
        if (vFieldsProvider != null) {
            vFieldsProvider.fillFields(pFieldsToCollect);
        }
        SrcFeatureFields.defaultFillFields(pSrcContent, pFieldsToCollect);
    }

    protected static void defaultFillFields(ISrcContent pSrcContent, IFieldsCollector pFieldsToCollect) throws Exception {
        pFieldsToCollect.startIterate();
        String vKeyData = pFieldsToCollect.nextUnfilledDataKey();
        while (vKeyData != null) {
            if (vKeyData == DATAKEY_URI) {
                ISrcNode vNode = pSrcContent.getAspect(ISrcNode.TYPE);
                if (vNode != null) {
                    pFieldsToCollect.setData(vKeyData, vNode.getSrcUri());
                }
            } else if (vKeyData == DATAKEY_LASTMODIF) {
                pFieldsToCollect.setData(vKeyData, pSrcContent.getLastModif());
            } else if (vKeyData == DATAKEY_TREELASTMODIF) {
                pFieldsToCollect.setData(vKeyData, pSrcContent.getLastModifWithChildren());
            } else if (vKeyData == DATAKEY_CONTENTSIZE) {
                pFieldsToCollect.setData(vKeyData, pSrcContent.getContentSize());
            } else if (vKeyData == DATAKEY_CONTENTTYPE) {
                pFieldsToCollect.setData(vKeyData, pSrcContent.getContentType());
            } else if (vKeyData == DATAKEY_CONTENTSTATUS) {
                pFieldsToCollect.setData(vKeyData, pSrcContent.getContentStatus());
            } else if (vKeyData == DATAKEY_ID) {
                IIdAspect vIdAspect = pSrcContent.getAspect(IIdAspect.TYPE);
                if (vIdAspect != null) {
                    pFieldsToCollect.setData(vKeyData, vIdAspect.getSrcId(false));
                }
            } else if (vKeyData == DATAKEY_RIGHTS) {
                pFieldsToCollect.setData(vKeyData, SrcFeatureRights.getAllowedRights(pSrcContent));
            }
            vKeyData = pFieldsToCollect.nextUnfilledDataKey();
        }
    }
}

