/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.history;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.SrcFeatureFields;
import com.scenari.src.feature.history.IHistoryNodeAspect;
import com.scenari.src.feature.history.IRestoreNodeAspect;
import com.scenari.src.feature.history.ITrashedNodesAspect;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcFeatureHistory {
    public static final String DATAKEY_LIVEURI = FieldsCollectorBuilder.declareDataKey("srcLiveUri");

    public static List<ISrcNode> getHistoryNodes(ISrcNode pSrc) throws Exception {
        IHistoryNodeAspect vAspect = pSrc.getAspect(IHistoryNodeAspect.TYPE);
        if (vAspect != null) {
            return vAspect.getHistoryNodes();
        }
        return null;
    }

    public static ISrcNode getHistoryNode(ISrcNode pSrc, String pRefUri) throws Exception {
        IHistoryNodeAspect vAspect = pSrc.getAspect(IHistoryNodeAspect.TYPE);
        if (vAspect != null) {
            return vAspect.getHistoryNode(pRefUri);
        }
        return null;
    }

    public static List<ISrcNode> getTrashedNodes(ISrcNode pSrc) throws Exception {
        ITrashedNodesAspect vAspect = pSrc.getAspect(ITrashedNodesAspect.TYPE);
        if (vAspect != null) {
            return vAspect.getTrashedNodes();
        }
        return null;
    }

    public static ISrcNode getTrashedNode(ISrcNode pSrc, String pRefUri) throws Exception {
        ITrashedNodesAspect vAspect = pSrc.getAspect(ITrashedNodesAspect.TYPE);
        if (vAspect != null) {
            return vAspect.getTrashedNode(pRefUri);
        }
        return null;
    }

    public static String getLiveUri(ISrcContent pSrc) throws Exception {
        if (pSrc == null) {
            return null;
        }
        IFieldsCollector vFieldCollector = FieldsCollectorBuilder.newFieldsCollector(DATAKEY_LIVEURI);
        SrcFeatureFields.fillFields(pSrc, vFieldCollector);
        return (String)vFieldCollector.getData(DATAKEY_LIVEURI);
    }

    public static ISrcNode restoreNode(ISrcNode pSrc, Map<String, Object> pOptions) throws Exception {
        IRestoreNodeAspect vAspect = pSrc.getAspect(IRestoreNodeAspect.TYPE);
        if (vAspect != null) {
            return vAspect.restoreNode(pOptions);
        }
        return null;
    }
}

