/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.ids;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.AspectNotFoundException;
import com.scenari.src.feature.ids.IFindContentByIdAspect;
import com.scenari.src.feature.ids.IFindNodeByIdAspect;
import com.scenari.src.feature.ids.IFindUriByIdAspect;
import com.scenari.src.feature.ids.IIdAspect;

public class SrcFeatureIds {
    public static ISrcContent findContentById(ISrcServer pSrc, String pSrcId) throws Exception {
        if (pSrcId == null) {
            return null;
        }
        IFindContentByIdAspect vAspect = pSrc.getAspect(IFindContentByIdAspect.TYPE);
        if (vAspect != null) {
            return vAspect.findContentById(pSrcId);
        }
        IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
        if (vFindUriAspect != null) {
            return pSrc.findContentByUri(vFindUriAspect.findUriById(pSrcId));
        }
        throw new AspectNotFoundException(IFindContentByIdAspect.class.getName());
    }

    public static ISrcNode findNodeById(ISrcNode pSrc, String pSrcId) throws Exception {
        if (pSrcId == null) {
            return pSrc;
        }
        IFindNodeByIdAspect vAspect = pSrc.getAspect(IFindNodeByIdAspect.TYPE);
        if (vAspect != null) {
            return vAspect.findNodeById(pSrcId);
        }
        IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
        if (vFindUriAspect != null) {
            String vUri = vFindUriAspect.findUriById(pSrcId);
            return vUri != null ? pSrc.findNodeByUri(vUri) : null;
        }
        throw new AspectNotFoundException(IFindNodeByIdAspect.class.getName());
    }

    public static String findUriById(ISrcServer pSrc, String pSrcId) throws Exception {
        if (pSrcId == null) {
            return null;
        }
        IFindUriByIdAspect vAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
        if (vAspect != null) {
            return vAspect.findUriById(pSrcId);
        }
        throw new AspectNotFoundException(IFindUriByIdAspect.class.getName());
    }

    public static ISrcContent findContentByRefUri(ISrcServer pSrc, String pRefUri) throws Exception {
        if (pRefUri == null) {
            return null;
        }
        if (SrcFeatureIds.isSrcId(pRefUri)) {
            IFindContentByIdAspect vAspect = pSrc.getAspect(IFindContentByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findContentById(pRefUri);
            }
            IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vFindUriAspect != null) {
                return pSrc.findContentByUri(vFindUriAspect.findUriById(pRefUri));
            }
            throw new AspectNotFoundException(IFindContentByIdAspect.class.getName());
        }
        return pSrc.findContentByUri(pRefUri);
    }

    public static ISrcNode findNodeByRefUri(ISrcNode pSrc, String pRefUri) throws Exception {
        if (pRefUri == null) {
            return pSrc;
        }
        if (SrcFeatureIds.isSrcId(pRefUri)) {
            IFindNodeByIdAspect vAspect = pSrc.getAspect(IFindNodeByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findNodeById(pRefUri);
            }
            IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vFindUriAspect != null) {
                return pSrc.findNodeByUri(vFindUriAspect.findUriById(pRefUri));
            }
            throw new AspectNotFoundException(IFindNodeByIdAspect.class.getName());
        }
        return pSrc.findNodeByUri(pRefUri);
    }

    public static String findUriByRefUri(ISrcServer pSrc, String pRefUri) throws Exception {
        if (pRefUri == null) {
            return null;
        }
        if (SrcFeatureIds.isSrcId(pRefUri)) {
            IFindUriByIdAspect vAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findUriById(pRefUri);
            }
            throw new AspectNotFoundException(IFindUriByIdAspect.class.getName());
        }
        return pRefUri;
    }

    public static String getSrcId(ISrcContent pSrcContent) throws Exception {
        IIdAspect vIdAspect = pSrcContent.getAspect(IIdAspect.TYPE);
        if (vIdAspect != null) {
            return vIdAspect.getSrcId(false);
        }
        return null;
    }

    public static String getOrCreateSrcId(ISrcContent pSrcContent) throws Exception {
        IIdAspect vIdAspect = pSrcContent.getAspect(IIdAspect.TYPE);
        if (vIdAspect != null) {
            return vIdAspect.getSrcId(true);
        }
        return null;
    }

    public static boolean isSrcId(String pRefUri) {
        return pRefUri != null && pRefUri.startsWith("id:");
    }

    public static final String extractIdValueFromSrcId(String pSrcId) {
        if (pSrcId == null) {
            return null;
        }
        return pSrcId.substring("id:".length());
    }

    public static final String buildSrcIdFromIdValue(String pIdValue) {
        if (pIdValue == null) {
            return null;
        }
        return "id:".concat(pIdValue);
    }
}

