/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.paths;

import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.AspectNotFoundException;
import com.scenari.src.feature.ids.IFindContentByIdAspect;
import com.scenari.src.feature.ids.IFindNodeByIdAspect;
import com.scenari.src.feature.ids.IFindUriByIdAspect;
import com.scenari.src.feature.paths.IPathResolverAspect;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.src.feature.paths.LazySaxInputSource;
import com.scenari.src.helpers.base.SrcNodeContentWrapper;
import eu.scenari.fw.log.LogMgr;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SrcFeaturePaths {
    public static final String PROTOCOL_INTERN = "intern:";
    public static final String PROTOCOL_INTERN_SLASH = "intern:/";

    public static ISrcContent findContentByPath(ISrcNode pSrc, String pPath, boolean pFromFile) throws Exception {
        if (pPath == null) {
            return pSrc;
        }
        if (SrcFeaturePaths.isPathId(pPath)) {
            IFindContentByIdAspect vAspect = pSrc.getAspect(IFindContentByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findContentById(pPath);
            }
            IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vFindUriAspect != null) {
                return pSrc.findContentByUri(vFindUriAspect.findUriById(pPath));
            }
            throw new AspectNotFoundException(IFindContentByIdAspect.class.getName());
        }
        IPathResolverAspect vAspect = pSrc.getAspect(IPathResolverAspect.TYPE);
        if (vAspect != null) {
            return vAspect.findContentByPath(pPath, pFromFile);
        }
        String vUri = SrcFeaturePaths.resolvePath2Uri(pPath, pSrc.getSrcUri(), pFromFile);
        if (vUri == null) {
            return ISrcContent.NULL;
        }
        return pSrc.findContentByUri(vUri);
    }

    public static ISrcNode findNodeByPath(ISrcNode pSrc, String pPath, boolean pFromFile) throws Exception {
        if (pPath == null) {
            return pSrc;
        }
        if (SrcFeaturePaths.isPathId(pPath)) {
            IFindNodeByIdAspect vAspect = pSrc.getAspect(IFindNodeByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findNodeById(pPath);
            }
            IFindUriByIdAspect vFindUriAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vFindUriAspect != null) {
                return pSrc.findNodeByUri(vFindUriAspect.findUriById(pPath));
            }
            throw new AspectNotFoundException(IFindNodeByIdAspect.class.getName());
        }
        IPathResolverAspect vAspect = pSrc.getAspect(IPathResolverAspect.TYPE);
        if (vAspect != null) {
            return vAspect.findNodeByPath(pPath, pFromFile);
        }
        String vUri = SrcFeaturePaths.resolvePath2Uri(pPath, pSrc.getSrcUri(), pFromFile);
        if (vUri == null) {
            return ISrcNode.NULL;
        }
        return pSrc.findNodeByUri(vUri);
    }

    public static String findUriByPath(ISrcServer pSrc, String pPath, String pFromUri, boolean pFromFile) throws Exception {
        if (pPath == null) {
            return pFromUri;
        }
        if (SrcFeaturePaths.isPathId(pPath)) {
            IFindUriByIdAspect vAspect = pSrc.getAspect(IFindUriByIdAspect.TYPE);
            if (vAspect != null) {
                return vAspect.findUriById(pPath);
            }
            throw new AspectNotFoundException(IFindUriByIdAspect.class.getName());
        }
        return SrcFeaturePaths.resolvePath2Uri(pPath, pFromUri, pFromFile);
    }

    public static String resolvePath2Uri(String pPath, String pFromUri, boolean pFromIsFile) throws Exception {
        if (pPath == null || pFromUri == null) {
            return pFromUri;
        }
        if (pPath.length() == 0) {
            return "";
        }
        if (SrcFeaturePaths.isPathId(pPath)) {
            throw new Exception("Path Id '" + pPath + "' can't be resolved as Uri.");
        }
        StringBuilder vBuf = null;
        int vOffset = 0;
        if (pPath.charAt(0) == '/') {
            vBuf = new StringBuilder(pPath.length());
            vOffset = 1;
        } else if (pFromIsFile) {
            int vLastSlash = pFromUri.lastIndexOf(47);
            if (vLastSlash > 0) {
                vBuf = new StringBuilder(vLastSlash + pPath.length());
                vBuf.append(pFromUri.substring(0, vLastSlash));
            } else {
                vBuf = new StringBuilder(pPath.length());
            }
        } else {
            vBuf = new StringBuilder(pFromUri.length() + pPath.length());
            vBuf.append(pFromUri);
        }
        int vNext = pPath.indexOf(47, vOffset);
        if (vNext < 0) {
            vNext = pPath.length();
        }
        while (vNext >= 0) {
            int vL = vNext - vOffset;
            if (vL == 1) {
                if (pPath.charAt(vOffset) != '.') {
                    vBuf.append('/');
                    vBuf.append(pPath.charAt(vOffset));
                }
            } else if (vL == 2) {
                if (pPath.charAt(vOffset) == '.' && pPath.charAt(vOffset + 1) == '.') {
                    int vLast = vBuf.lastIndexOf("/");
                    if (vLast < 0) {
                        return null;
                    }
                    vBuf.setLength(vLast);
                } else {
                    vBuf.append('/');
                    vBuf.append(pPath.charAt(vOffset));
                    vBuf.append(pPath.charAt(vOffset + 1));
                }
            } else if (vL > 0) {
                vBuf.append('/');
                for (int i = vOffset; i < vNext; ++i) {
                    vBuf.append(pPath.charAt(i));
                }
            }
            if (vNext == pPath.length()) {
                vNext = -1;
                continue;
            }
            vOffset = vNext + 1;
            if ((vNext = pPath.indexOf(47, vOffset)) >= 0) continue;
            vNext = pPath.length();
        }
        return vBuf.toString();
    }

    public static boolean checkPathScope(String pPath, String pFromUri, boolean pFromFile) {
        if (pPath == null || pPath.length() == 0) {
            return true;
        }
        int vOffset2pt = pPath.indexOf("..");
        if (vOffset2pt < 0) {
            return true;
        }
        int vCountSlash = 0;
        if (pPath.charAt(0) != '/') {
            int vOffsetSlash = pFromUri.indexOf(47, 1);
            while (vOffsetSlash > 0) {
                ++vCountSlash;
                vOffsetSlash = pFromUri.indexOf(47, vOffsetSlash + 1);
            }
            if (pFromFile) {
                --vCountSlash;
            }
        }
        int vLastOffsetPathSlash = 0;
        while (vOffset2pt >= 0) {
            if (!(vOffset2pt != 0 && pFromUri.charAt(vOffset2pt - 1) != '/' || vOffset2pt != pPath.length() - 2 && pFromUri.charAt(vOffset2pt + 2) != '/')) {
                --vCountSlash;
                for (int i = vLastOffsetPathSlash + 1; i < vOffset2pt; ++i) {
                    if (pPath.charAt(i) != '/') continue;
                    ++vCountSlash;
                }
                if (vCountSlash < 0) {
                    return false;
                }
                vLastOffsetPathSlash = vOffset2pt;
            }
            vOffset2pt = pPath.indexOf("..", vOffset2pt + 2);
        }
        return true;
    }

    public static boolean isPathAbsolute(String pPath) {
        return pPath != null && (pPath.length() == 0 || pPath.charAt(0) == '/');
    }

    public static boolean isPathId(String pPath) {
        return pPath != null && pPath.startsWith("id:");
    }

    public static SrcNodeResolver newSrcNodeResolver(ISrcNode pSrc, ISrcAliasResolver pAliasResolver) throws Exception {
        if (pSrc instanceof SrcNodeResolver) {
            throw new Exception("Never wrap a SrcNodeResolver on a SrcNodeResolver...");
        }
        return new SrcNodeResolver(pSrc, pAliasResolver);
    }

    public static String getXmlSystemId(ISrcNode pSrc) {
        return PROTOCOL_INTERN_SLASH.concat(pSrc.getSrcUri());
    }

    public static String getPathFromXmlSystemId(String pXmlSystemId) {
        if (pXmlSystemId.startsWith(PROTOCOL_INTERN)) {
            if (pXmlSystemId.length() > PROTOCOL_INTERN_SLASH.length() && pXmlSystemId.charAt(PROTOCOL_INTERN.length()) == '/') {
                return pXmlSystemId.substring(PROTOCOL_INTERN_SLASH.length());
            }
            return pXmlSystemId.substring(PROTOCOL_INTERN.length());
        }
        return pXmlSystemId;
    }

    public static class SrcNodeResolver
    extends SrcNodeContentWrapper
    implements URIResolver,
    EntityResolver {
        protected ISrcAliasResolver fAliasResolver = null;

        public SrcNodeResolver(ISrcNode pSrc, ISrcAliasResolver pAliasResolver) {
            super(pSrc);
            this.fAliasResolver = pAliasResolver;
        }

        public ISrcAliasResolver getAliasResolver() {
            return this.fAliasResolver;
        }

        public void setAliasResolver(ISrcAliasResolver pAliasResolver) {
            this.fAliasResolver = pAliasResolver;
        }

        protected ISrcContent xCreateSrcContent(ISrcContent pSubSource) {
            return pSubSource;
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) {
            return new SrcNodeResolver(pSubSource, this.fAliasResolver);
        }

        public Source resolve(String pHref, String pBase) throws TransformerException {
            Source vResult = null;
            try {
                SrcNodeResolver vResolvedSrc;
                pHref = SrcFeaturePaths.getPathFromXmlSystemId(pHref);
                pBase = SrcFeaturePaths.getPathFromXmlSystemId(pBase);
                ISrcNode vFrom = this;
                if (pBase != null && !vFrom.getSrcUri().equals(pBase)) {
                    try {
                        vFrom = this.findNodeByPath(pBase, true);
                        vFrom = vFrom == ISrcNode.NULL ? this : new SrcNodeResolver(vFrom, this.fAliasResolver);
                    }
                    catch (Exception e) {
                        vFrom = this;
                    }
                }
                if ((vResolvedSrc = new SrcNodeResolver(SrcFeaturePaths.findNodeByPath(vFrom, pHref, true), this.fAliasResolver)).getContentStatus() == 1) {
                    XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReaderAutoPooling(true, false);
                    LazySaxInputSource vInputSource = new LazySaxInputSource(vResolvedSrc);
                    vInputSource.setSystemId(SrcFeaturePaths.getXmlSystemId(vResolvedSrc));
                    vResult = new SAXSource(vReader, vInputSource);
                    ((SAXSource)vResult).getXMLReader().setEntityResolver(vResolvedSrc);
                } else {
                    vResult = new StreamSource(new StringReader("<fileNotFound href=\"" + pHref + "\"/>"));
                }
            }
            catch (Exception e) {
                throw (TransformerException)LogMgr.addMessage((Throwable)new TransformerException(e), "La r\u00e9solution de l'uri " + pHref + " avec la base " + pBase + " a \u00e9chou\u00e9e.", new String[0]);
            }
            return vResult;
        }

        public InputSource resolveEntity(String pPublicId, String pSystemID) throws SAXException, IOException {
            LazySaxInputSource vResult = null;
            try {
                pSystemID = SrcFeaturePaths.getPathFromXmlSystemId(pSystemID);
                if (pSystemID.indexOf(58) > 0) {
                    vResult = new LazySaxInputSource(new URL(pSystemID));
                    vResult.setSystemId(pSystemID);
                } else {
                    ISrcNode vRes = this.findNodeByPath(pSystemID, true);
                    if (vRes.getContentStatus() == 1) {
                        vResult = new LazySaxInputSource(vRes);
                        vResult.setSystemId(vRes.getSrcUri());
                    }
                }
            }
            catch (IOException e) {
                throw (IOException)LogMgr.addMessage((Throwable)e, "La r\u00e9solution de l'entit\u00e9 '" + pSystemID + "' a \u00e9chou\u00e9e.", new String[0]);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "La r\u00e9solution de l'entit\u00e9 '" + pSystemID + "' a \u00e9chou\u00e9e.", new String[0]);
                throw (SAXException)LogMgr.addMessage(new SAXException(e), LogMgr.getMessage(e));
            }
            return vResult;
        }

        public ISrcContent findContentByPath(String pPath, boolean pFromFile) throws Exception {
            if (this.fAliasResolver != null) {
                return SrcFeaturePaths.findContentByPath(this.getSubSrcNode(), this.fAliasResolver.resolveAlias(pPath), pFromFile);
            }
            return SrcFeaturePaths.findContentByPath(this.getSubSrcNode(), pPath, pFromFile);
        }

        public ISrcNode findNodeByPath(String pPath, boolean pFromFile) throws Exception {
            if (this.fAliasResolver != null) {
                return SrcFeaturePaths.findNodeByPath(this.getSubSrcNode(), this.fAliasResolver.resolveAlias(pPath), pFromFile);
            }
            return SrcFeaturePaths.findNodeByPath(this.getSubSrcNode(), pPath, pFromFile);
        }

        public String toString() {
            return "<SrcNodeResolver uri=\"" + this.getSrcUri() + "\"/>";
        }
    }
}

