/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.random;

import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.random.IRandomAspect;

public class SrcFeatureRandom {
    public static ISrcNode newRandomFile(ISrcNode pSrc, String pPrefixPath, String pSuffixUri) throws Exception {
        IRandomAspect vAspect;
        String vPrefixName = "";
        ISrcNode vParent = pSrc;
        if (pPrefixPath != null) {
            int vOffs = pPrefixPath.lastIndexOf(47);
            if (vOffs < 0) {
                vPrefixName = pPrefixPath;
            } else {
                vParent = SrcFeaturePaths.findNodeByPath(pSrc, pPrefixPath.substring(0, ++vOffs), false);
                vPrefixName = pPrefixPath.substring(vOffs);
            }
        }
        if ((vAspect = vParent.getAspect(IRandomAspect.TYPE)) != null) {
            return vAspect.newRandomFile(vParent.getSrcUri(), vPrefixName, pSuffixUri);
        }
        ISrcNode vChild = null;
        if (vParent != null) {
            boolean vOk = false;
            String vID = null;
            while (!vOk) {
                vID = Long.toString(Math.round(Math.random() * 100000.0));
                vChild = vParent.findNodeChild(new StringBuilder(vPrefixName.length() + vID.length() + pSuffixUri.length()).append(vPrefixName).append(vID).append(pSuffixUri).toString());
                if (vChild == null) continue;
                vOk = vChild.createAsFile();
            }
        }
        return vChild;
    }

    public static ISrcNode newRandomFolder(ISrcNode pSrc, String pPrefixPath, String pSuffixUri) throws Exception {
        IRandomAspect vAspect;
        String vPrefixName = "";
        ISrcNode vParent = pSrc;
        if (pPrefixPath != null) {
            int vOffs = pPrefixPath.lastIndexOf(47);
            if (vOffs < 0) {
                vPrefixName = pPrefixPath;
            } else {
                vParent = SrcFeaturePaths.findNodeByPath(pSrc, pPrefixPath.substring(0, ++vOffs), false);
                vPrefixName = pPrefixPath.substring(vOffs);
            }
        }
        if ((vAspect = vParent.getAspect(IRandomAspect.TYPE)) != null) {
            return vAspect.newRandomFolder(vParent.getSrcUri(), vPrefixName, pSuffixUri);
        }
        ISrcNode vChild = null;
        if (vParent != null) {
            boolean vOk = false;
            String vID = null;
            while (!vOk) {
                vID = Long.toString(Math.round(Math.random() * 100000.0));
                vChild = vParent.findNodeChild(new StringBuilder(vPrefixName.length() + vID.length() + pSuffixUri.length()).append(vPrefixName).append(vID).append(pSuffixUri).toString());
                if (vChild == null) continue;
                vOk = vChild.createAsFolder();
            }
        }
        return vChild;
    }
}

