/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.refresh;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.aspect.ISrcAspectable;
import com.scenari.src.aspect.SrcAspectDef;
import com.scenari.src.feature.refresh.IRefreshAspect;

public class SrcFeatureRefresh {
    public static final ISrcAspectDef<Boolean> REFIND_SRCCONTENT_FOR_REFRESH = new SrcAspectDef<Boolean>(Boolean.class);

    public static boolean refresh(ISrcAspectable pSrc) throws Exception {
        IRefreshAspect vAspect = pSrc.getAspect(IRefreshAspect.TYPE);
        if (vAspect != null) {
            return vAspect.refresh();
        }
        return true;
    }

    public static boolean isUpdated(ISrcContent pSrc, long pLastModif) throws Exception {
        if (pLastModif == -1L) {
            return false;
        }
        SrcFeatureRefresh.refresh(pSrc);
        long vNewLastModif = pSrc.getLastModifWithChildren();
        if (vNewLastModif == -1L) {
            return false;
        }
        return vNewLastModif != pLastModif;
    }

    public static boolean isUpdatedOrUnknown(ISrcContent pSrc, long pLastModif) throws Exception {
        if (pLastModif == -1L) {
            return true;
        }
        SrcFeatureRefresh.refresh(pSrc);
        long vNewLastModif = pSrc.getLastModifWithChildren();
        if (vNewLastModif == -1L) {
            return true;
        }
        return vNewLastModif != pLastModif;
    }

    public static ISrcContent refreshContentFromServer(ISrcServer pServer, String pUri, ISrcContent pOldContent) throws Exception {
        if (!SrcFeatureRefresh.refresh(pServer)) {
            return null;
        }
        if (pOldContent == null || pServer.getAspect(REFIND_SRCCONTENT_FOR_REFRESH) == Boolean.TRUE) {
            return pServer.findContentByUri(pUri);
        }
        if (!SrcFeatureRefresh.refresh(pOldContent)) {
            return pServer.findContentByUri(pUri);
        }
        return pOldContent;
    }
}

