/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.relocate;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.AspectNotFoundException;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.relocate.IRelocateAsChildAspect;
import com.scenari.src.feature.relocate.IRelocateAsRootAspect;
import com.scenari.src.feature.relocate.IRelocateAsSubTreeAspect;
import com.scenari.src.feature.relocate.IRelocateParentAspect;
import com.scenari.src.feature.uris.SrcFeatureUris;
import com.scenari.src.helpers.base.SrcNodeContentWrapper;
import com.scenari.src.helpers.util.SrcNodeConflict;

public class SrcFeatureRelocate {
    public static ISrcNode relocateAsRoot(ISrcNode pSrcNode) throws Exception {
        IRelocateAsRootAspect vRelocateAspect = pSrcNode.getAspect(IRelocateAsRootAspect.TYPE);
        if (vRelocateAspect != null) {
            return vRelocateAspect.relocateAsRoot();
        }
        return new RelocateRootWrapper(pSrcNode);
    }

    public static ISrcNode relocateAsSubTree(ISrcNode pSrcNode, String pUri) throws Exception {
        IRelocateAsSubTreeAspect vRelocateAspect = pSrcNode.getAspect(IRelocateAsSubTreeAspect.TYPE);
        if (vRelocateAspect != null) {
            return vRelocateAspect.relocateAsSubTree(pUri);
        }
        return new RelocateSubTreeWrapper(pSrcNode, pUri);
    }

    public static ISrcNode relocateAsChild(ISrcNode pChild, ISrcNode pParent, String pChildName) throws Exception {
        IRelocateParentAspect vParentAspect = pParent.getAspect(IRelocateParentAspect.TYPE);
        if (vParentAspect == null) {
            throw new AspectNotFoundException("IRelocateParent not implemented for " + pParent);
        }
        IRelocateAsChildAspect vChildAspect = pChild.getAspect(IRelocateAsChildAspect.TYPE);
        ISrcNode vNewChild = null;
        if (vChildAspect != null) {
            vNewChild = vChildAspect.relocateAsChild(pParent, pChildName);
        }
        if (vNewChild == null) {
            throw new Exception("Relocate child Wrapper not implemented.");
        }
        vParentAspect.setRelocatedChild(vNewChild, pChildName);
        return vNewChild;
    }

    protected static class RelocateSubTreeWrapper
    extends RelocateRootWrapper {
        protected String fRootTreeUri;

        public RelocateSubTreeWrapper(ISrcNode pSubSource, String pRootTreeUri) {
            super(pSubSource);
            this.fRootTreeUri = pRootTreeUri;
        }

        protected RelocateSubTreeWrapper(ISrcNode pSubSource, String pSubSrcRootUri, String pRootTreeUri, String pUri) {
            super(pSubSource, pSubSrcRootUri, pUri);
            this.fRootTreeUri = pRootTreeUri;
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) {
            String vUri = this.xSubUri2Uri(pSubSource.getSrcUri());
            if (vUri == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return new RelocateSubTreeWrapper(pSubSource, this.fSubSrcRootUri, this.fRootTreeUri, vUri);
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource, String pUri) {
            return new RelocateSubTreeWrapper(pSubSource, this.fSubSrcRootUri, this.fRootTreeUri, pUri);
        }

        protected String xUri2SubUri(String pUri) {
            if (SrcFeatureUris.isAncestorOrSameUri(this.fRootTreeUri, pUri)) {
                return this.fSubSrcRootUri.concat(pUri.substring(this.fRootTreeUri.length()));
            }
            return null;
        }

        protected String xSubUri2Uri(String pUri) {
            if (SrcFeatureUris.isAncestorOrSameUri(this.fSubSrcRootUri, pUri)) {
                return this.fRootTreeUri.concat(pUri.substring(this.fSubSrcRootUri.length()));
            }
            return null;
        }

        protected String xPath2SubPath(String pPath) {
            if (SrcFeaturePaths.isPathAbsolute(pPath)) {
                return this.xUri2SubUri(pPath);
            }
            return pPath;
        }

        protected boolean xControlPathContext(String pPath, String pFromUri, boolean pFromFile) throws Exception {
            if (SrcFeaturePaths.isPathAbsolute(pPath) && !SrcFeatureUris.isAncestorOrSameUri(this.fRootTreeUri, pPath)) {
                return false;
            }
            return SrcFeaturePaths.checkPathScope(pPath, pFromUri.substring(this.fRootTreeUri.length()), pFromFile);
        }
    }

    protected static class RelocateRootWrapper
    extends SrcNodeContentWrapper
    implements IRelocateAsRootAspect,
    IRelocateAsSubTreeAspect {
        protected String fSubSrcRootUri;
        protected String fUri;

        public RelocateRootWrapper(ISrcNode pSubSource) {
            super(pSubSource);
            this.fSubSrcRootUri = pSubSource.getSrcUri();
            this.fUri = "";
        }

        protected RelocateRootWrapper(ISrcNode pSubSource, String pSubSrcRootUri, String pUri) {
            super(pSubSource);
            this.fSubSrcRootUri = pSubSrcRootUri;
            this.fUri = pUri;
        }

        protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition == IRelocateAsRootAspect.TYPE) {
                return this;
            }
            if (pDefinition == IRelocateAsSubTreeAspect.TYPE) {
                return this;
            }
            return super.getAspectForThis(pDefinition);
        }

        protected boolean isAspectFromSubSourceAllowed(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition.canResolvePath()) {
                return false;
            }
            return super.isAspectFromSubSourceAllowed(pDefinition);
        }

        protected ISrcContent xCreateSrcContent(ISrcContent pSubSource) {
            return pSubSource;
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) {
            String vUri = this.xSubUri2Uri(pSubSource.getSrcUri());
            if (vUri == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return new RelocateRootWrapper(pSubSource, this.fSubSrcRootUri, vUri);
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource, String pUri) {
            return new RelocateRootWrapper(pSubSource, this.fSubSrcRootUri, pUri);
        }

        protected String xUri2SubUri(String pUri) {
            return this.fSubSrcRootUri.concat(pUri);
        }

        protected String xPath2SubPath(String pPath) {
            if (SrcFeaturePaths.isPathAbsolute(pPath)) {
                return this.fSubSrcRootUri.concat(pPath);
            }
            return pPath;
        }

        protected String xSubUri2Uri(String pUri) {
            return pUri.substring(this.fSubSrcRootUri.length());
        }

        protected boolean xControlPathContext(String pPath, String pFromUri, boolean pFromFile) throws Exception {
            return SrcFeaturePaths.checkPathScope(pPath, pFromUri, pFromFile);
        }

        public String getSrcUri() {
            return this.fUri;
        }

        public ISrcContent findContentByUri(String pUri) throws Exception {
            String vUri = this.xUri2SubUri(pUri);
            if (vUri == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return this.getSubSrcNode().findContentByUri(vUri);
        }

        public ISrcNode findNodeByUri(String pUri) throws Exception {
            String vUri = this.xUri2SubUri(pUri);
            if (vUri == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return this.xCreateSrcNode(this.getSubSrcNode().findNodeByUri(vUri), pUri);
        }

        public ISrcContent findContentByPath(String pPath, boolean pFromFile) throws Exception {
            if (!this.xControlPathContext(pPath, this.fUri, pFromFile)) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            String vPath = this.xPath2SubPath(pPath);
            if (vPath == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return super.findContentByPath(vPath, pFromFile);
        }

        public ISrcNode findNodeByPath(String pPath, boolean pFromFile) throws Exception {
            if (!this.xControlPathContext(pPath, this.fUri, pFromFile)) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            String vPath = this.xPath2SubPath(pPath);
            if (vPath == null) {
                return SrcNodeConflict.URI_OUT_OF_SCOPE;
            }
            return super.findNodeByPath(vPath, pFromFile);
        }

        public ISrcNode relocateAsRoot() throws Exception {
            return new RelocateRootWrapper(this.getSubSrcNode());
        }

        public ISrcNode relocateAsSubTree(String pNewUri) throws Exception {
            return new RelocateSubTreeWrapper(this.getSubSrcNode(), pNewUri);
        }
    }
}

