/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.rights;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectable;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.helpers.util.SrcContentRestrictRights;
import com.scenari.src.helpers.util.SrcNodeRestrictRights;

public class SrcFeatureRights {
    public static final int RIGHT_READ = 1;
    public static final int RIGHT_LISTCHILDREN = 2;
    public static final int RIGHT_WRITE = 4;
    public static final int RIGHT_REMOVE = 8;
    public static final int RIGHTONCHILDREN_REMOVE = 16;
    public static final int RIGHT_CREATEFILE = 32;
    public static final int RIGHT_CREATEFOLDER = 64;
    public static final int RIGHTONCHILDREN_CREATE = 128;
    public static final int RIGHT_MOVE = 256;
    public static final int RIGHTS_UPDATES = 508;
    public static final int RIGHTS_READ = 3;
    public static final int RIGHTS_ALL = 511;

    public static int getAllowedRights(ISrcAspectable pSrc) throws Exception {
        int vResult = 511;
        IAccessRightsAspect vAspect = pSrc.getAspect(IAccessRightsAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.getRights();
        }
        return vResult;
    }

    public static boolean isAllowed(ISrcAspectable pSrc, int pRequiredRights) throws Exception {
        return (pRequiredRights & ~SrcFeatureRights.getAllowedRights(pSrc)) == 0;
    }

    public static ISrcContent restrictRightsContent(ISrcContent pSrc, int pRights) throws Exception {
        return new SrcContentRestrictRights(pSrc, pRights);
    }

    public static ISrcNode restrictRightsNode(ISrcNode pSrc, int pRights) throws Exception {
        return new SrcNodeRestrictRights(pSrc, pRights);
    }
}

