/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.search;

import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.aspect.SrcAspectDef;
import com.scenari.src.feature.search.ISearchAspect;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchRequest;
import com.scenari.src.search.ISearchRequestCompiled;
import com.scenari.src.search.ISearchRequestEditable;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.impl.RequestCompiled;
import com.scenari.src.search.impl.RequestEditable;
import com.scenari.src.search.impl.RequestSaxHandler;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcFeatureSearch {
    public static final ISrcAspectDef<Boolean> SKIP_SCANNING_FOLDER_ASPECTTYPE = new SrcAspectDef<Boolean>(Boolean.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISearchRequestEditable parseXmlRequest(InputStream pRequest) throws Exception {
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            RequestSaxHandler vHandler = new RequestSaxHandler();
            vHandler.initSaxHandlerForRoot(vXmlReader);
            vXmlReader.setContentHandler(vHandler);
            vXmlReader.parse(new InputSource(pRequest));
            RequestEditable requestEditable = vHandler.getRequest();
            return requestEditable;
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISearchRequestEditable parseXmlRequest(Reader pRequest) throws Exception {
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            RequestSaxHandler vHandler = new RequestSaxHandler();
            vHandler.initSaxHandlerForRoot(vXmlReader);
            vXmlReader.setContentHandler(vHandler);
            vXmlReader.parse(new InputSource(pRequest));
            RequestEditable requestEditable = vHandler.getRequest();
            return requestEditable;
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vXmlReader);
        }
    }

    public static ISearchRequestEditable newRequest() throws Exception {
        return new RequestEditable();
    }

    public static ISearchRequestCompiled compileRequest(ISearchRequest pRequest, ISrcServer pFromSrc) throws Exception {
        ArrayList<ISearchExecutor> vExecutors = new ArrayList<ISearchExecutor>();
        SrcFeatureSearch.listExecutors(pFromSrc, vExecutors);
        RequestCompiled vReq = new RequestCompiled(pRequest, pFromSrc);
        vReq.compile(pRequest, vExecutors);
        return vReq;
    }

    public static ISearchRequestCompiled compileRequest(ISearchRequest pRequest, ISrcServer pFromSrc, List<ISearchExecutor> pExecutors) throws Exception {
        ArrayList<ISearchExecutor> vExecutors = new ArrayList<ISearchExecutor>(pExecutors);
        RequestCompiled vReq = new RequestCompiled(pRequest, pFromSrc);
        vReq.compile(pRequest, vExecutors);
        return vReq;
    }

    public static Iterator<ISearchResultRow> execute(ISearchRequest pRequest, ISrcServer pFromSrc) throws Exception {
        ISearchRequestCompiled vReqC = SrcFeatureSearch.compileRequest(pRequest, pFromSrc);
        return vReqC.execute(null);
    }

    public static void listExecutors(ISrcServer pFromSrc, List<ISearchExecutor> pExecutors) throws Exception {
        ISearchAspect vAspect = pFromSrc.getAspect(ISearchAspect.TYPE);
        if (vAspect != null) {
            vAspect.listExecutors(pExecutors);
        }
    }
}

