/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.streams;

import com.scenari.src.ISrcContent;
import com.scenari.src.feature.streams.IStreamsAspect;
import com.scenari.src.feature.streams.IWriteFromInputAspect;
import com.scenari.src.feature.streams.IWriteToOutputAspect;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.IBlob;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.Checksum;

public class SrcFeatureStreams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFrom(ISrcContent pSrc, InputStream pIn) throws Exception {
        block6: {
            try {
                IWriteFromInputAspect vAspect = pSrc.getAspect(IWriteFromInputAspect.TYPE);
                if (vAspect != null) {
                    vAspect.writeFrom(pIn);
                    break block6;
                }
                OutputStream vOut = pSrc.newOutputStream(false);
                try {
                    StreamUtils.write(pIn, vOut);
                }
                finally {
                    vOut.close();
                }
            }
            catch (Exception e) {
                pIn.close();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(ISrcContent pSrc, OutputStream pOut, boolean pCloseOut) throws Exception {
        try {
            IWriteToOutputAspect vAspect = pSrc.getAspect(IWriteToOutputAspect.TYPE);
            if (vAspect != null) {
                vAspect.writeTo(pOut);
            } else {
                StreamUtils.write(pSrc.newInputStream(false), pOut);
            }
        }
        finally {
            if (pCloseOut) {
                pOut.close();
            }
        }
    }

    public static IBlob wrapSrcAsBlob(ISrcContent pSrc) throws Exception {
        return new BlobFromSrcContent(pSrc);
    }

    public static Reader newReader(ISrcContent pSrc, String pEncoding) throws Exception {
        Reader vResult = null;
        IStreamsAspect vAspect = pSrc.getAspect(IStreamsAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.newReader(pEncoding);
        }
        if (vResult == null) {
            vResult = pEncoding != null ? new InputStreamReader(pSrc.newInputStream(false), pEncoding) : new InputStreamReader(pSrc.newInputStream(false));
        }
        return vResult;
    }

    public static Writer newWriter(ISrcContent pSrc, String pEncoding) throws Exception {
        Writer vResult = null;
        IStreamsAspect vAspect = pSrc.getAspect(IStreamsAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.newWriter(pEncoding);
        }
        if (vResult == null) {
            vResult = pEncoding != null ? new OutputStreamWriter(pSrc.newOutputStream(false), pEncoding) : new OutputStreamWriter(pSrc.newOutputStream(false));
        }
        return vResult;
    }

    public static OutputStream newOutputStreamAppend(ISrcContent pSrc, boolean pEnsureBuffered) throws Exception {
        OutputStream vResult = null;
        IStreamsAspect vAspect = pSrc.getAspect(IStreamsAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.newOutputStreamAppend(pEnsureBuffered);
        }
        if (vResult == null) {
            throw new Exception("TODO...");
        }
        return vResult;
    }

    public static Writer newWriterAppend(ISrcContent pSrc, String pEncoding) throws Exception {
        Writer vResult = null;
        IStreamsAspect vAspect = pSrc.getAspect(IStreamsAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.newWriterAppend(pEncoding);
        }
        if (vResult == null) {
            throw new Exception("TODO...");
        }
        return vResult;
    }

    public static class BlobFromSrcContent
    implements IBlob {
        protected ISrcContent fSrcContent;

        public BlobFromSrcContent(ISrcContent pSrcContent) {
            this.fSrcContent = pSrcContent;
        }

        public String getContentType() {
            try {
                return this.fSrcContent.getContentType();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                return null;
            }
        }

        public int getLength() {
            try {
                return this.fSrcContent.getContentSize();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                return -1;
            }
        }

        public void closeStream() {
            this.fSrcContent = null;
        }

        public InputStream getInputStream(boolean pCloseWhenInputStreamIsClosed) throws Exception {
            return this.fSrcContent.newInputStream(true);
        }

        public IBlob transformAsBlob() throws Exception {
            return this;
        }

        public void writeIn(OutputStream pStream) throws Exception {
            SrcFeatureStreams.writeTo(this.fSrcContent, pStream, false);
        }

        public void computeCheckSum(Checksum pCheckSum) throws Exception {
            throw new Exception("Not implemented");
        }
    }

    public static class RedirectOutpuStreamToWriteFrom
    extends OutputStreamBlob {
        protected ISrcContent fSrc;

        public RedirectOutpuStreamToWriteFrom(ISrcContent pSrc) {
            this.fSrc = pSrc;
        }

        public void close() throws IOException {
            try {
                SrcFeatureStreams.writeFrom(this.fSrc, this.getInputStream(true));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)LogMgr.addMessage(new IOException(e.getMessage()), LogMgr.getMessage(e));
            }
        }
    }
}

