/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.transform;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.HTransformerMgr;
import com.scenari.s.co.transform.IHTransformMgr;
import com.scenari.s.co.transform.IHTransformer;
import com.scenari.s.co.transform.TransformContentException;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.transform.ITransformAsNodeAspect;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.feature.transform.ITransformedNodeAspect;
import com.scenari.src.helpers.base.SrcNodeWrapper;
import com.scenari.src.helpers.util.SrcNodeFromBlob;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;

public class SrcFeatureTransform {
    public static IByteStream transformContent(ISrcContent pSrc, HTransformParams pParams) throws TransformContentException, Exception {
        IByteStream vResult = null;
        ITransformAspect vAspect = pSrc.getAspect(ITransformAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.transform(pParams);
        }
        if (vResult != null) {
            return vResult;
        }
        return SrcFeatureTransform.defaultTransformAsStream(pSrc, pParams);
    }

    public static ISrcNode transformAsNode(ISrcNode pSrc, HTransformParams pParams, boolean pPreserveContext) throws TransformContentException, Exception {
        ISrcNode vResult = null;
        ITransformAsNodeAspect vAspect = pSrc.getAspect(ITransformAsNodeAspect.TYPE);
        if (vAspect != null) {
            vResult = vAspect.transformAsNode(pParams);
        }
        if (vResult == null) {
            vResult = SrcFeatureTransform.defaultTransformAsNode(pSrc, pParams);
        }
        if (pPreserveContext && vResult != null) {
            vResult = new TransformedNode(vResult, pSrc, pParams);
        }
        return vResult;
    }

    public static String getTransformUri(ISrcNode pSrc) throws Exception {
        if (pSrc == null) {
            return null;
        }
        ITransformedNodeAspect vTrNode = pSrc.getAspect(ITransformedNodeAspect.TYPE);
        if (vTrNode != null) {
            return vTrNode.getTransformUri();
        }
        return null;
    }

    public static String getTransformUriFromOriginalSrc(ISrcNode pSrc) throws Exception {
        if (pSrc == null) {
            return null;
        }
        ITransformedNodeAspect vTrNode = pSrc.getAspect(ITransformedNodeAspect.TYPE);
        String vTrUri = null;
        if (vTrNode != null) {
            vTrUri = vTrNode.getTransformUri();
            String vParentTrUri = SrcFeatureTransform.getTransformUriFromOriginalSrc(vTrNode.getTransformSource());
            if (vParentTrUri != null) {
                vTrUri = vParentTrUri.concat(vTrUri);
            }
        }
        return vTrUri;
    }

    public static ISrcNode findNodeByTransformUri(ISrcNode pSrcOrigin, String pTransformUri) throws TransformContentException, Exception {
        String vFirstUri;
        int vLengthTransformUri = pTransformUri.length();
        ISrcNode vResult = pSrcOrigin;
        int vStartUri = 0;
        int vStartParams = pTransformUri.indexOf(59);
        String string = vFirstUri = vStartParams < 0 ? pTransformUri : pTransformUri.substring(vStartUri, vStartParams);
        if (!vResult.getSrcUri().equals(vFirstUri)) {
            vResult = vResult.findNodeByUri(vFirstUri);
        }
        while (vStartParams >= 0) {
            HTransformParams vTransformParams;
            int vEndParams = pTransformUri.indexOf(47, vStartParams);
            if (vEndParams < 0) {
                pTransformUri.indexOf(59, vStartParams);
            }
            if (vEndParams < 0) {
                vEndParams = vLengthTransformUri;
            }
            if ((vResult = SrcFeatureTransform.transformAsNode(vResult, vTransformParams = HTransformParams.hNewParamsTransformByQueryString(pTransformUri.substring(vStartParams + 1, vEndParams), "UTF-8"), true)) == null) {
                return null;
            }
            vStartUri = vEndParams;
            vStartParams = vStartUri < vLengthTransformUri ? pTransformUri.indexOf(59, vStartUri) : -1;
            String vRequestedUri = pTransformUri.substring(vStartUri, vStartParams < 0 ? vLengthTransformUri : vStartParams);
            if (vResult.getSrcUri().equals(vRequestedUri)) continue;
            vResult = vResult.findNodeByUri(vRequestedUri);
        }
        return vResult;
    }

    public static ISrcNode defaultTransformAsNode(ISrcNode pSrc, HTransformParams pParams) throws TransformContentException, Exception {
        IHTransformer vTransformer;
        SrcNodeFromBlob vResult = null;
        IHTransformMgr vTransformerMgr = HTransformerMgr.hGetTransformerMgr(null);
        if (vTransformerMgr != null && (vTransformer = vTransformerMgr.hGetTransformer(pParams)) != null) {
            ISrcNode vSrc = vTransformer.hIsSrcAllowed(ISrcContent.class, pParams) ? pSrc : pSrc.newInputStream(true);
            OutputStreamBlob vOutStream = new OutputStreamBlob();
            vOutStream.setContentType(vTransformer.hGetMimeType(pParams));
            vTransformer.hTransform(vSrc, vOutStream, pParams);
            vResult = new SrcNodeFromBlob(vOutStream);
        }
        return vResult;
    }

    public static IByteStream defaultTransformAsStream(ISrcContent pSrc, HTransformParams pParams) throws TransformContentException, Exception {
        IHTransformer vTransformer;
        OutputStreamBlob vResult = null;
        IHTransformMgr vTransformerMgr = HTransformerMgr.hGetTransformerMgr(null);
        if (vTransformerMgr != null && (vTransformer = vTransformerMgr.hGetTransformer(pParams)) != null) {
            vResult = new OutputStreamBlob();
            if (vTransformer.hIsSrcAllowed(ISrcContent.class, pParams)) {
                vTransformer.hTransform(pSrc, vResult, pParams);
            } else {
                vTransformer.hTransform(pSrc.newInputStream(true), vResult, pParams);
            }
            vResult.setContentType(vTransformer.hGetMimeType(pParams));
        }
        return vResult;
    }

    public static class TransformedNode
    extends SrcNodeWrapper
    implements ITransformedNodeAspect {
        protected ISrcNode fTransformSource = null;
        protected HTransformParams fTransformParams = null;
        protected String fTransformUri = null;

        public TransformedNode(ISrcNode pSubSource, ISrcNode pTranformSource, HTransformParams pParams) {
            super(pSubSource);
            this.fTransformSource = pTranformSource;
            this.fTransformParams = pParams;
        }

        protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
            if (pDefinition == ITransformedNodeAspect.TYPE) {
                return this;
            }
            return super.getAspectForThis(pDefinition);
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) throws Exception {
            return new TransformedNode(this.getSubSrcNode(), this.fTransformSource, this.fTransformParams);
        }

        public HTransformParams getTransformParams() throws Exception {
            return this.fTransformParams;
        }

        public ISrcNode getTransformSource() throws Exception {
            return this.fTransformSource;
        }

        public synchronized String getTransformUri() throws Exception {
            if (this.fTransformUri == null) {
                StringBuilder vBuf = PoolBuffers.popStringBuilder();
                vBuf.append(this.fTransformSource.getSrcUri());
                vBuf.append(';');
                this.fTransformParams.hGetQueryStringBuilderFromThis(vBuf);
                vBuf.append(this.getSrcUri());
                this.fTransformUri = PoolBuffers.getStringAndFreeStringBuilder(vBuf);
            }
            return this.fTransformUri;
        }
    }
}

