/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.feature.uris;

import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.aspect.SrcAspectDef;

public class SrcFeatureUris {
    public static final ISrcAspectDef<Object> SRCROOT_ASPECT = new SrcAspectDef<Object>(Object.class);

    public static boolean hasSameRoot(ISrcServer pSrc1, ISrcServer pSrc2, boolean pReturnTrueIfNoRoot) throws Exception {
        Object vRoot1 = pSrc1.getAspect(SRCROOT_ASPECT);
        Object vRoot2 = pSrc2.getAspect(SRCROOT_ASPECT);
        if (vRoot1 == null && vRoot2 == null) {
            return pReturnTrueIfNoRoot;
        }
        if (vRoot1 == null || vRoot2 == null) {
            return false;
        }
        return vRoot1.equals(vRoot2);
    }

    public static boolean isAncestorOrSameUri(String pUriAncestor, String pUriDescendant) {
        int vAncLen = pUriAncestor.length();
        int vDescLen = pUriDescendant.length();
        return (vDescLen == vAncLen || vDescLen > vAncLen && pUriDescendant.charAt(vAncLen) == '/') && pUriDescendant.startsWith(pUriAncestor);
    }

    public static boolean isAncestor(String pUriAncestor, String pUriDescendant) {
        int vAncLen = pUriAncestor.length();
        int vDescLen = pUriDescendant.length();
        return vDescLen > vAncLen && pUriDescendant.charAt(vAncLen) == '/' && pUriDescendant.startsWith(pUriAncestor);
    }
}

