/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.fs.basic;

import com.scenari.src.fs.basic.FsBasicSystem;
import com.scenari.src.fs.mini.FsMiniSrcContentCheckCase;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;

public class FsBasicSrcContent
extends FsMiniSrcContentCheckCase {
    protected FsBasicSystem fSystem = null;
    protected long fLastUpdate = -1L;
    protected long fLastScan = -1L;

    protected FsBasicSrcContent(FsBasicSystem pSystem, String pUri) {
        super(pUri);
        this.fSystem = pSystem;
    }

    protected FsBasicSrcContent(FsBasicSystem pSystem, File pRoot, String pUri) {
        super(pRoot, pUri);
        this.fSystem = pSystem;
    }

    protected boolean isCheckCase() {
        return this.fSystem.isCheckCase();
    }

    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        return super.newOutputStream(pEnsureBuffered);
    }

    public OutputStream newOutputStreamAppend(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        return super.newOutputStreamAppend(pEnsureBuffered);
    }

    public Writer newWriter(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        return super.newWriter(pEncoding);
    }

    public Writer newWriterAppend(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        return super.newWriterAppend(pEncoding);
    }

    public boolean removeSrc() throws Exception {
        this.fLastScan = -1L;
        return super.removeSrc();
    }

    public long getLastModifWithChildren() throws Exception {
        int vElapse = this.fSystem.getElapseMsScanUpdates();
        if (vElapse < 0) {
            return this.xGetLastModifWithChilds(this, 0L);
        }
        if (this.fLastScan > 0L && this.fLastScan + (long)vElapse >= System.currentTimeMillis()) {
            return this.fLastUpdate;
        }
        this.fLastUpdate = this.xGetLastModifWithChilds(this, 0L);
        this.fLastScan = System.currentTimeMillis();
        return this.fLastUpdate;
    }

    public boolean refresh() throws Exception {
        this.fLastScan = -1L;
        return true;
    }
}

