/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.fs.basic;

import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.relocate.IRelocateAsSubTreeAspect;
import com.scenari.src.fs.basic.FsBasicSrcContent;
import com.scenari.src.fs.basic.FsBasicSystem;
import com.scenari.src.fs.mini.FsMiniSrcContent;
import com.scenari.src.fs.mini.FsMiniSrcNode;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;

public class FsBasicSrcNode
extends FsMiniSrcNode
implements IRelocateAsSubTreeAspect {
    protected FsBasicSystem fSystem = null;
    protected long fLastUpdate = -1L;
    protected long fLastScan = -1L;

    protected FsBasicSrcNode(FsBasicSystem pSystem, String pPhysicalPath) {
        super(pPhysicalPath);
        this.fSystem = pSystem;
    }

    protected FsBasicSrcNode(FsBasicSystem pSystem, File pParent, String pPhysicalPath) {
        super(pParent, pPhysicalPath);
        this.fSystem = pSystem;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IRelocateAsSubTreeAspect.TYPE) {
            return this;
        }
        return super.getAspect(pDefinition);
    }

    protected FsMiniSrcNode initNode(String pLogicalUri, File pPhysicalFileRoot) {
        return super.initNode(pLogicalUri, pPhysicalFileRoot);
    }

    protected boolean isCheckCase() {
        return this.fSystem.isCheckCase();
    }

    protected FsMiniSrcNode newNode(File pParent, String pPhysicalPath) {
        return new FsBasicSrcNode(this.fSystem, pParent, pPhysicalPath);
    }

    protected FsMiniSrcContent newContent(File pParent, String pPhysicalPath) {
        return new FsBasicSrcContent(this.fSystem, pParent, pPhysicalPath);
    }

    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        return super.newOutputStream(pEnsureBuffered);
    }

    public OutputStream newOutputStreamAppend(boolean pEnsureBuffered) throws Exception {
        this.fLastScan = -1L;
        return super.newOutputStreamAppend(pEnsureBuffered);
    }

    public Writer newWriter(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        return super.newWriter(pEncoding);
    }

    public Writer newWriterAppend(String pEncoding) throws Exception {
        this.fLastScan = -1L;
        return super.newWriterAppend(pEncoding);
    }

    public boolean removeSrc() throws Exception {
        this.fLastScan = -1L;
        return super.removeSrc();
    }

    public long getLastModifWithChildren() throws Exception {
        int vElapse = this.fSystem.getElapseMsScanUpdates();
        if (vElapse < 0) {
            return this.xGetLastModifWithChilds(this, 0L);
        }
        if (this.fLastScan > 0L && this.fLastScan + (long)vElapse >= System.currentTimeMillis()) {
            return this.fLastUpdate;
        }
        this.fLastUpdate = this.xGetLastModifWithChilds(this, 0L);
        this.fLastScan = System.currentTimeMillis();
        return this.fLastUpdate;
    }

    public ISrcNode relocateAsSubTree(String pNewUri) throws Exception {
        FsBasicSubTreeSrcNode vResult = new FsBasicSubTreeSrcNode(this.fSystem, this.fFileRoot, this.fUri, pNewUri);
        vResult.initNode("", vResult);
        return vResult;
    }

    public boolean refresh() throws Exception {
        this.fLastScan = -1L;
        return true;
    }

    public static class FsBasicSubTreeSrcNode
    extends FsBasicSrcNode {
        protected String fPrefixUri = null;
        protected String fPublicUri = null;

        protected FsBasicSubTreeSrcNode(FsBasicSystem pSystem, File pParent, String pPhysicalPath, String pPrefixUri) {
            super(pSystem, pParent, pPhysicalPath);
            this.fPrefixUri = pPrefixUri;
        }

        protected FsMiniSrcNode newNode(File pParent, String pPhysicalPath) {
            return new FsBasicSubTreeSrcNode(this.fSystem, pParent, pPhysicalPath, this.fPrefixUri);
        }

        protected FsMiniSrcNode initNode(String pLogicalUri, File pPhysicalFileRoot) {
            this.fPublicUri = pLogicalUri.length() > 0 ? this.fPrefixUri.concat(pLogicalUri) : this.fPrefixUri;
            return super.initNode(pLogicalUri, pPhysicalFileRoot);
        }

        public String getSrcUri() {
            return this.fPublicUri;
        }

        public ISrcNode relocateAsRoot() throws Exception {
            File vFileRoot = new File(this.getPath());
            return new FsBasicSrcNode(this.fSystem, vFileRoot, "").initNode("", vFileRoot);
        }
    }
}

