/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.fs.mini;

import com.scenari.src.ISrcContent;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.streams.IStreamsAspect;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FsMiniSrcContent
extends File
implements ISrcContent,
IAccessRightsAspect,
IStreamsAspect,
IRefreshAspect,
IFieldsProviderAspect {
    protected FsMiniSrcContent(String pCanonicalPath) {
        super(pCanonicalPath);
    }

    protected FsMiniSrcContent(File pParent, String pPhysicalPath) {
        super(pParent, pPhysicalPath);
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        if (pDefinition == IStreamsAspect.TYPE) {
            return this;
        }
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
            return this.getAbsolutePath();
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this;
        }
        return pDefinition == ISrcContent.TYPE ? this : null;
    }

    @Override
    public boolean createAsFile() throws Exception {
        this.getParentFile().mkdirs();
        return this.createNewFile();
    }

    @Override
    public boolean createAsFolder() throws Exception {
        return this.mkdirs();
    }

    @Override
    public int getContentSize() throws Exception {
        return (int)this.length();
    }

    @Override
    public int getContentStatus() throws Exception {
        if (this.isFile()) {
            return 1;
        }
        if (this.isDirectory()) {
            return 2;
        }
        return -1;
    }

    @Override
    public String getContentType() throws Exception {
        return null;
    }

    @Override
    public long getLastModif() throws Exception {
        return this.lastModified();
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        return this.xGetLastModifWithChilds(this, 0L);
    }

    public List<String> listChildrenNames(List pListToAppend, int pStatusChildren) throws Exception {
        List<String> vResult;
        block6: {
            block5: {
                vResult = null;
                if (pStatusChildren != 0) break block5;
                String[] vFiles = this.list();
                if (vFiles == null) break block6;
                vResult = Arrays.asList(vFiles);
                break block6;
            }
            File[] vFiles = this.listFiles();
            if (vFiles != null) {
                vResult = new ArrayList<String>(vFiles.length);
                if (pStatusChildren == 2) {
                    for (int i = 0; i < vFiles.length; ++i) {
                        if (!vFiles[i].isDirectory()) continue;
                        vResult.add(vFiles[i].getName());
                    }
                } else {
                    for (int i = 0; i < vFiles.length; ++i) {
                        if (!vFiles[i].isFile()) continue;
                        vResult.add(vFiles[i].getName());
                    }
                }
            }
        }
        return vResult;
    }

    @Override
    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        if (this.isFile() && this.canRead()) {
            return pEnsureBuffered ? new BufferedInputStream(new FileInputStream(this)) : new FileInputStream(this);
        }
        return null;
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        if (pEnsureBuffered) {
            return new BufferedOutputStream(new FileOutputStream(this, false));
        }
        return new FileOutputStream(this, false);
    }

    @Override
    public boolean removeSrc() throws Exception {
        return FsMiniSrcContent.tryDeleteFiles(this, 3);
    }

    @Override
    public OutputStream newOutputStreamAppend(boolean pEnsureBuffered) throws Exception {
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        if (pEnsureBuffered) {
            return new BufferedOutputStream(new FileOutputStream(this, true));
        }
        return new FileOutputStream(this, true);
    }

    @Override
    public Reader newReader(String pEncoding) throws Exception {
        if (this.isFile() && this.canRead()) {
            if (pEncoding == null) {
                return new InputStreamReader(new FileInputStream(this));
            }
            return new InputStreamReader((InputStream)new FileInputStream(this), pEncoding);
        }
        return null;
    }

    @Override
    public Writer newWriter(String pEncoding) throws Exception {
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this, false), pEncoding);
    }

    @Override
    public Writer newWriterAppend(String pEncoding) throws Exception {
        if (!this.exists()) {
            this.getParentFile().mkdirs();
            this.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this, true), pEncoding);
    }

    @Override
    public int getRights() throws Exception {
        return this.canWrite() || !this.exists() ? 511 : 3;
    }

    @Override
    public boolean refresh() throws Exception {
        return true;
    }

    @Override
    public void fillFields(IFieldsCollector pFieldsToCollect) throws Exception {
        SrcFeatureAlternateUrl.fillFields(this, pFieldsToCollect);
    }

    public static boolean deleteFiles(File pFile) {
        if (pFile.isDirectory()) {
            File[] vFiles = pFile.listFiles();
            if (vFiles != null) {
                for (int i = 0; i < vFiles.length; ++i) {
                    FsMiniSrcContent.deleteFiles(vFiles[i]);
                }
            }
            return pFile.delete();
        }
        return pFile.delete();
    }

    public static boolean tryDeleteFiles(File pFile, int pNbTry) {
        int vCount = 0;
        while (!FsMiniSrcContent.deleteFiles(pFile)) {
            if (vCount < pNbTry) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++vCount;
                continue;
            }
            return false;
        }
        return true;
    }

    protected long xGetLastModifWithChilds(File pFile, long pMostRecentModif) {
        if (pFile.isDirectory()) {
            if (!pFile.getName().equals(".svn")) {
                pMostRecentModif = Math.max(pMostRecentModif, this.lastModified());
                File[] vFiles = pFile.listFiles();
                if (vFiles != null) {
                    for (int i = 0; i < vFiles.length; ++i) {
                        pMostRecentModif = Math.max(pMostRecentModif, vFiles[i].lastModified());
                        pMostRecentModif = this.xGetLastModifWithChilds(vFiles[i], pMostRecentModif);
                    }
                }
            }
            return pMostRecentModif;
        }
        return Math.max(pMostRecentModif, pFile.lastModified());
    }
}

