/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.fs.mini;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.relocate.IRelocateAsRootAspect;
import com.scenari.src.fs.mini.FsMiniSrcContent;
import com.scenari.src.fs.mini.FsMiniSrcContentCheckCase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FsMiniSrcNode
extends FsMiniSrcContentCheckCase
implements ISrcNode,
IRelocateAsRootAspect {
    protected File fFileRoot = null;

    protected FsMiniSrcNode(String pCanonicalPath) {
        super(pCanonicalPath);
    }

    protected FsMiniSrcNode(File pParent, String pPath) {
        super(pParent, pPath);
    }

    @Override
    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IRelocateAsRootAspect.TYPE) {
            return this;
        }
        return super.getAspect(pDefinition);
    }

    protected FsMiniSrcNode initNode(String pLogicalUri, File pPhysicalFileRoot) {
        this.fUri = pLogicalUri;
        this.fFileRoot = pPhysicalFileRoot;
        return this;
    }

    protected FsMiniSrcNode newNode(File pParent, String pPhysicalPath) {
        return new FsMiniSrcNode(pParent, pPhysicalPath);
    }

    protected FsMiniSrcContent newContent(File pParent, String pPhysicalPath) {
        return this.isCheckCase() ? new FsMiniSrcContentCheckCase(pParent, pPhysicalPath) : new FsMiniSrcContent(pParent, pPhysicalPath);
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        String vUri = this.fUri + "/" + pChildName;
        return this.newNode(this, pChildName).initNode(vUri, this.fFileRoot);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        return this.newNode(this.fFileRoot, pUri).initNode(pUri, this.fFileRoot);
    }

    @Override
    public String getSrcName() {
        return this.getName();
    }

    @Override
    public String getSrcUri() {
        return this.fUri;
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        String[] vFiles = this.list();
        if (vFiles == null) {
            return null;
        }
        if (vFiles.length == 0) {
            return Collections.emptyList();
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<ISrcNode>(vFiles.length);
        }
        StringBuilder vSb = new StringBuilder(this.fUri.length() + 65);
        vSb.append(this.fUri);
        vSb.append('/');
        int vOffsetParent = vSb.length();
        for (String vName : vFiles) {
            vSb.append(vName);
            pListToAppend.add(this.newNode(this, vName).initNode(vSb.toString(), this.fFileRoot));
            vSb.setLength(vOffsetParent);
        }
        return pListToAppend;
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.newContent(this.fFileRoot, pUri);
    }

    @Override
    public ISrcNode relocateAsRoot() throws Exception {
        File vFileRoot = new File(this.getPath());
        return this.newNode(vFileRoot, "").initNode("", vFileRoot);
    }
}

