/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.base;

import com.scenari.src.ISrcContent;
import com.scenari.src.aspect.ISrcAspectDef;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrcContentWrapper
implements ISrcContent {
    protected ISrcContent fSubSrcContent;

    public SrcContentWrapper(ISrcContent pSource) {
        this.fSubSrcContent = pSource;
    }

    @Override
    public <T> T getAspect(ISrcAspectDef<T> pDefinition) throws Exception {
        Object vResult = this.getAspectForThis(pDefinition);
        if (vResult != null) {
            return (T)vResult;
        }
        if (this.isAspectFromSubSourceAllowed(pDefinition)) {
            return this.fSubSrcContent.getAspect(pDefinition);
        }
        return null;
    }

    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcContent.TYPE) {
            return this;
        }
        return null;
    }

    protected boolean isAspectFromSubSourceAllowed(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition.isBijection()) {
            return false;
        }
        return !pDefinition.canInstantiateSrcContent() && !pDefinition.canInstantiateSrcNode();
    }

    public ISrcContent getSubSrcNode() {
        return this.fSubSrcContent;
    }

    @Override
    public String getContentType() throws Exception {
        return this.getSubSrcNode().getContentType();
    }

    @Override
    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        return this.getSubSrcNode().newInputStream(pEnsureBuffered);
    }

    @Override
    public long getLastModif() throws Exception {
        return this.getSubSrcNode().getLastModif();
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        return this.getSubSrcNode().getLastModifWithChildren();
    }

    @Override
    public List<String> listChildrenNames(List<String> pListToAppend, int pStatusChilds) throws Exception {
        return this.getSubSrcNode().listChildrenNames(pListToAppend, pStatusChilds);
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        return this.getSubSrcNode().newOutputStream(pEnsureBuffered);
    }

    @Override
    public int getContentSize() throws Exception {
        return this.getSubSrcNode().getContentSize();
    }

    @Override
    public int getContentStatus() throws Exception {
        return this.getSubSrcNode().getContentStatus();
    }

    @Override
    public boolean createAsFile() throws Exception {
        return this.getSubSrcNode().createAsFile();
    }

    @Override
    public boolean createAsFolder() throws Exception {
        return this.getSubSrcNode().createAsFolder();
    }

    @Override
    public boolean removeSrc() throws Exception {
        return this.getSubSrcNode().removeSrc();
    }
}

