/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.base;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.history.IHistoryNodeAspect;
import com.scenari.src.feature.history.ITrashedNodesAspect;
import com.scenari.src.feature.history.SrcFeatureHistory;
import com.scenari.src.feature.paths.IPathResolverAspect;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.versions.INetVersionNodeAspect;
import com.scenari.src.feature.versions.SrcFeatureVersions;
import com.scenari.src.helpers.base.SrcContentWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrcNodeWrapper
extends SrcContentWrapper
implements ISrcNode,
IPathResolverAspect,
IHistoryNodeAspect,
ITrashedNodesAspect,
INetVersionNodeAspect {
    public SrcNodeWrapper(ISrcNode pSubSource) {
        super(pSubSource);
    }

    public SrcNodeWrapper(ISrcContent pSubSource) {
        super(pSubSource);
    }

    @Override
    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcNode.TYPE) {
            return this;
        }
        if (pDefinition == IPathResolverAspect.TYPE) {
            return this;
        }
        if (pDefinition == IHistoryNodeAspect.TYPE && this.getSubSrcNode().getAspect(IPathResolverAspect.TYPE) != null) {
            return this;
        }
        if (pDefinition == INetVersionNodeAspect.TYPE && this.getSubSrcNode().getAspect(INetVersionNodeAspect.TYPE) != null) {
            return this;
        }
        if (pDefinition == ITrashedNodesAspect.TYPE && this.getSubSrcNode().getAspect(ITrashedNodesAspect.TYPE) != null) {
            return this;
        }
        return super.getAspectForThis(pDefinition);
    }

    protected abstract ISrcNode xCreateSrcNode(ISrcNode var1) throws Exception;

    @Override
    public ISrcNode getSubSrcNode() {
        return (ISrcNode)this.fSubSrcContent;
    }

    @Override
    public ISrcContent findContentByPath(String pPath, boolean pFromFile) throws Exception {
        return this.xCreateSrcNode(SrcFeaturePaths.findNodeByPath(this.getSubSrcNode(), pPath, pFromFile));
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.xCreateSrcNode(this.getSubSrcNode().findNodeByUri(pUri));
    }

    @Override
    public ISrcNode findNodeByPath(String pPath, boolean pFromFile) throws Exception {
        return this.xCreateSrcNode(SrcFeaturePaths.findNodeByPath(this.getSubSrcNode(), pPath, pFromFile));
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        return this.xCreateSrcNode(this.getSubSrcNode().findNodeChild(pChildName));
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        return this.xCreateSrcNode(this.getSubSrcNode().findNodeByUri(pUri));
    }

    @Override
    public String getSrcName() {
        return this.getSubSrcNode().getSrcName();
    }

    public String hGetUri() {
        return this.getSrcUri();
    }

    @Override
    public String getSrcUri() {
        return this.getSubSrcNode().getSrcUri();
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        List<ISrcNode> vChList = this.getSubSrcNode().listChildrenNodes(null);
        if (vChList == null) {
            return null;
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<ISrcNode>(vChList.size());
        }
        for (int i = 0; i < vChList.size(); ++i) {
            pListToAppend.add(this.xCreateSrcNode(vChList.get(i)));
        }
        return pListToAppend;
    }

    @Override
    public List<ISrcNode> getHistoryNodes() throws Exception {
        List<ISrcNode> vList = SrcFeatureHistory.getHistoryNodes(this.getSubSrcNode());
        if (vList != null) {
            ArrayList<ISrcNode> vNewList = new ArrayList<ISrcNode>(vList.size());
            for (ISrcNode vSrcNode : vList) {
                vNewList.add(this.xCreateSrcNode(vSrcNode));
            }
            return vNewList;
        }
        return null;
    }

    @Override
    public ISrcNode getHistoryNode(String pRefUri) throws Exception {
        ISrcNode vEntry = SrcFeatureHistory.getHistoryNode(this.getSubSrcNode(), pRefUri);
        return vEntry != null ? this.xCreateSrcNode(vEntry) : null;
    }

    @Override
    public List<ISrcNode> getNetVersionNodes() throws Exception {
        List<ISrcNode> vList = SrcFeatureVersions.getNetVersionNodes(this.getSubSrcNode());
        if (vList != null) {
            ArrayList<ISrcNode> vNewList = new ArrayList<ISrcNode>(vList.size());
            for (ISrcNode vSrcNode : vList) {
                vNewList.add(this.xCreateSrcNode(vSrcNode));
            }
            return vNewList;
        }
        return null;
    }

    @Override
    public void createNetVersion(String pComment, Map<String, Object> pOptions) throws Exception {
        SrcFeatureVersions.createNetVersion(this.getSubSrcNode(), pComment, pOptions);
    }

    @Override
    public List<ISrcNode> getTrashedNodes() throws Exception {
        List<ISrcNode> vList = SrcFeatureHistory.getTrashedNodes(this.getSubSrcNode());
        if (vList != null) {
            ArrayList<ISrcNode> vNewList = new ArrayList<ISrcNode>(vList.size());
            for (ISrcNode vSrcNode : vList) {
                vNewList.add(this.xCreateSrcNode(vSrcNode));
            }
            return vNewList;
        }
        return null;
    }

    @Override
    public ISrcNode getTrashedNode(String pRefUri) throws Exception {
        return SrcFeatureHistory.getTrashedNode(this.getSubSrcNode(), pRefUri);
    }
}

