/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.lnk;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.AspectNotFoundException;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.ids.IFindContentByIdAspect;
import com.scenari.src.feature.ids.IFindUriByIdAspect;
import com.scenari.src.feature.paths.IPathResolverAspect;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.relocate.IRelocateAsRootAspect;
import com.scenari.src.helpers.base.SrcNodeBase;
import com.scenari.src.helpers.lnk.ISrcNodeLnk;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrcNodeLnkBase
extends SrcNodeBase
implements ISrcNodeLnk,
IPathResolverAspect,
IRelocateAsRootAspect,
Cloneable {
    protected ISrcNodeLnk fParent = null;
    protected String fName = null;

    public SrcNodeLnkBase() {
        this.xBuildUri();
    }

    @Override
    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IPathResolverAspect.TYPE) {
            return this;
        }
        if (pDefinition == IRelocateAsRootAspect.TYPE) {
            return this;
        }
        return super.getAspect(pDefinition);
    }

    @Override
    public ISrcNodeLnk findNodeLnk(String pPath, int pOffset) throws Exception {
        int vEnd;
        ISrcNodeLnk vResult = this;
        for (vEnd = pOffset; vEnd < pPath.length() && pPath.charAt(vEnd) != '/'; ++vEnd) {
        }
        int vLen = vEnd - pOffset;
        if (vLen != 0 && (vLen != 1 || pPath.charAt(pOffset) != '.')) {
            if (vLen == 2 && pPath.charAt(pOffset) == '.' && pPath.charAt(pOffset + 1) == '.') {
                vResult = this.getNodeLnkParent();
            } else {
                String vChildName = pPath.substring(pOffset, vEnd);
                vResult = this.findChild(vChildName);
            }
        }
        if (vResult != null && ++vEnd < pPath.length()) {
            vResult = vResult.findNodeLnk(pPath, vEnd);
        }
        return vResult == null ? ISrcNodeLnk.NULL : vResult;
    }

    protected abstract ISrcNodeLnk findChild(String var1) throws Exception;

    protected ISrcNodeLnk findNodeLnkByPath(String pPath, boolean pFromFile) throws Exception {
        if (pPath == null) {
            return this;
        }
        if (pPath.length() == 0) {
            pPath = "/";
        } else if (SrcFeaturePaths.isPathId(pPath)) {
            IFindUriByIdAspect vAspect = null;
            for (ISrcNodeLnk vNode = this; vNode != null && vAspect == null; vNode = vNode.getNodeLnkParent()) {
                vAspect = vNode.getAspect(IFindUriByIdAspect.TYPE);
            }
            if (vAspect != null) {
                pPath = vAspect.findUriById(pPath);
            } else {
                throw new AspectNotFoundException(IFindContentByIdAspect.class.getName());
            }
        }
        ISrcNodeLnk vResult = this;
        if (pPath.charAt(0) == '/') {
            ISrcNodeLnk vParent = vResult.getNodeLnkParent();
            while (vParent != null && !pPath.startsWith(vResult.getSrcUri())) {
                vResult = vParent;
                vParent = vResult.getNodeLnkParent();
            }
            vResult = vParent == null ? vResult.findNodeLnk(pPath, 1) : vResult.findNodeLnk(pPath, vResult.getSrcUri().length() + 1);
        } else {
            vResult = pFromFile ? this.getNodeLnkParent().findNodeLnk(pPath, 0) : this.findNodeLnk(pPath, 0);
        }
        return vResult;
    }

    @Override
    public ISrcNodeLnk getNodeLnkParent() {
        return this.fParent;
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        List<String> vList = this.listChildrenNames(null, 0);
        if (vList != null) {
            if (pListToAppend == null) {
                pListToAppend = new ArrayList<ISrcNode>(vList.size());
            }
            for (int i = 0; i < vList.size(); ++i) {
                String vChildName = vList.get(i);
                ISrcNodeLnk vSource = this.findChild(vChildName);
                if (vSource == null) continue;
                pListToAppend.add(vSource);
            }
            return pListToAppend;
        }
        return null;
    }

    @Override
    public final String getSrcName() {
        if (this.fParent == null) {
            return "";
        }
        return this.fName != null ? this.fName : this.getOriginalSrcName();
    }

    @Override
    public ISrcNodeLnk overideSrcName(String pName) {
        this.fName = pName;
        this.xBuildUri();
        return this;
    }

    protected abstract String getOriginalSrcName();

    @Override
    public ISrcNodeLnk setNodeLnkParent(ISrcNodeLnk pParent) throws Exception {
        this.fParent = pParent;
        this.xBuildUri();
        return this;
    }

    protected void xBuildUri() {
        if (this.fParent != null) {
            String vParentUri = this.fParent.getSrcUri();
            String vName = this.getSrcName();
            this.fUri = new StringBuilder(vParentUri.length() + 1 + vName.length()).append(vParentUri).append('/').append(vName).toString();
        } else {
            this.fUri = "";
        }
        if (this.fUri.startsWith("//")) {
            throw new NullPointerException("fUri::::" + this.fUri);
        }
        if (this.fUri.equals("/")) {
            throw new NullPointerException("fUri::::" + this.fUri);
        }
    }

    @Override
    public ISrcNode findNodeByPath(String pPath, boolean pFromFile) throws Exception {
        return this.findNodeLnkByPath(pPath, pFromFile);
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        return this.findChild(pChildName);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        assert (pUri != null);
        if (pUri == null) {
            return ISrcNode.NULL;
        }
        return this.findNodeByPath(pUri, false);
    }

    @Override
    public ISrcNode relocateAsRoot() throws Exception {
        ISrcNodeLnk vRes = (ISrcNodeLnk)this.clone();
        vRes.setNodeLnkParent(null);
        return vRes;
    }

    @Override
    public String toString() {
        return "<srcNodeLnk uri=\"" + this.getSrcUri() + "\"/>";
    }

    @Override
    public ISrcContent findContentByPath(String pPath, boolean pFromFile) throws Exception {
        return this.findNodeLnkByPath(pPath, pFromFile);
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        assert (pUri != null);
        if (pUri == null) {
            return ISrcContent.NULL;
        }
        return this.findContentByPath(pUri, false);
    }
}

