/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.lnk;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.helpers.lnk.ISrcNodeLnk;
import com.scenari.src.helpers.lnk.SrcNodeLnkBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SrcNodeLnkFrontEnd
extends SrcNodeLnkBase
implements IRefreshAspect {
    protected ISrcServer fBackEnd = null;
    protected String fBackEndUri = null;
    protected ISrcContent fSrcContent = null;

    public SrcNodeLnkFrontEnd(ISrcServer pBackEnd, String pUriBackEnd) {
        this.fBackEnd = pBackEnd;
        this.fBackEndUri = pUriBackEnd == null ? "" : pUriBackEnd;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        Object vResult = super.getAspect(pDefinition);
        if (vResult != null) {
            return vResult;
        }
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition.isBijection()) {
            return null;
        }
        return this.fSrcContent.getAspect(pDefinition);
    }

    protected ISrcNodeLnk findChild(String pName) throws Exception {
        return new SrcNodeLnkFrontEnd(this.fBackEnd, new StringBuilder(this.fBackEndUri.length() + 1 + pName.length()).append(this.fBackEndUri).append('/').append(pName).toString()).setNodeLnkParent(this);
    }

    public ISrcNodeLnk setNodeLnkParent(ISrcNodeLnk pParent) throws Exception {
        super.setNodeLnkParent(pParent);
        SrcFeatureRefresh.refresh(this);
        return this;
    }

    protected String getOriginalSrcName() {
        int vOffs = this.fBackEndUri.lastIndexOf(47);
        if (vOffs >= 0) {
            return this.fBackEndUri.substring(vOffs + 1);
        }
        return this.fBackEndUri;
    }

    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        return this.fSrcContent.newInputStream(pEnsureBuffered);
    }

    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        return this.fSrcContent.newOutputStream(pEnsureBuffered);
    }

    public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        return this.fSrcContent.listChildrenNames(pListToAppend, pStatusChilds);
    }

    public long getLastModifWithChildren() throws Exception {
        return this.fSrcContent.getLastModifWithChildren();
    }

    public int getContentSize() throws Exception {
        return this.fSrcContent.getContentSize();
    }

    public int getContentStatus() throws Exception {
        return this.fSrcContent.getContentStatus();
    }

    public boolean createAsFile() throws Exception {
        return this.fSrcContent.createAsFile();
    }

    public boolean createAsFolder() throws Exception {
        return this.fSrcContent.createAsFolder();
    }

    public boolean removeSrc() throws Exception {
        return this.fSrcContent.removeSrc();
    }

    public boolean refresh() throws Exception {
        ISrcContent vNewContent = SrcFeatureRefresh.refreshContentFromServer(this.fBackEnd, this.fUri, this.fSrcContent);
        if (vNewContent == null) {
            return false;
        }
        this.fSrcContent = vNewContent;
        return true;
    }
}

