/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcContent;
import com.scenari.src.NotAllowedException;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.rights.SrcFeatureRights;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SrcContentRestrictRights
implements ISrcContent,
IAccessRightsAspect {
    protected ISrcContent fSubSource = null;
    protected int fRights = 511;

    public SrcContentRestrictRights(ISrcContent pSource, int pRights) {
        this.fSubSource = pSource;
        this.fRights = pRights;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        Object vResult = this.fSubSource.getAspect(pDefinition);
        if (vResult != null) {
            if (SrcFeatureRights.isAllowed(this, pDefinition.rightsToCheck())) {
                return vResult;
            }
            throw new NotAllowedException();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this.fSubSource.equals(obj);
    }

    public int hashCode() {
        return this.fSubSource.hashCode();
    }

    public String getContentType() throws Exception {
        if ((this.fRights & 1) != 0) {
            return this.fSubSource.getContentType();
        }
        throw new NotAllowedException();
    }

    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        if ((this.fRights & 1) != 0) {
            return this.fSubSource.newInputStream(pEnsureBuffered);
        }
        throw new NotAllowedException();
    }

    public long getLastModif() throws Exception {
        if ((this.fRights & 1) != 0) {
            return this.fSubSource.getLastModif();
        }
        throw new NotAllowedException();
    }

    public long getLastModifWithChildren() throws Exception {
        if (SrcFeatureRights.isAllowed(this, 3)) {
            return this.fSubSource.getLastModifWithChildren();
        }
        throw new NotAllowedException();
    }

    public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        if ((this.fRights & 2) != 0) {
            return this.fSubSource.listChildrenNames(pListToAppend, pStatusChilds);
        }
        throw new NotAllowedException();
    }

    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        if ((this.fRights & 4) != 0) {
            return this.fSubSource.newOutputStream(pEnsureBuffered);
        }
        throw new NotAllowedException();
    }

    public int getRights() throws Exception {
        return this.fRights & SrcFeatureRights.getAllowedRights(this.fSubSource);
    }

    public int getContentSize() throws Exception {
        if ((this.fRights & 1) != 0) {
            return this.fSubSource.getContentSize();
        }
        throw new NotAllowedException();
    }

    public int getContentStatus() throws Exception {
        if ((this.fRights & 1) != 0) {
            return this.fSubSource.getContentStatus();
        }
        throw new NotAllowedException();
    }

    public boolean createAsFile() throws Exception {
        if ((this.fRights & 0x20) != 0) {
            return this.fSubSource.createAsFile();
        }
        throw new NotAllowedException();
    }

    public boolean createAsFolder() throws Exception {
        if ((this.fRights & 0x40) != 0) {
            return this.fSubSource.createAsFolder();
        }
        throw new NotAllowedException();
    }

    public boolean removeSrc() throws Exception {
        switch (this.fSubSource.getContentStatus()) {
            case 1: 
            case 2: {
                if ((this.fRights & 8) == 0) {
                    throw new NotAllowedException();
                }
                return this.fSubSource.removeSrc();
            }
        }
        return false;
    }

    public String toString() {
        return this.fSubSource.toString();
    }
}

