/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.s.co.transform.HTransformParams;
import com.scenari.s.co.transform.TransformContentException;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.transform.ITransformAspect;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import com.scenari.src.helpers.base.SrcContentWrapper;
import eu.scenari.fw.stream.bytes.IByteStream;
import eu.scenari.fw.stream.bytes.OutputStreamCounter;
import java.io.InputStream;

public class SrcContentTransform
extends SrcContentWrapper
implements ITransformAspect,
ISrcServer {
    protected HTransformParams fTransform = null;
    protected int fComputedSize = -1;

    public SrcContentTransform(ISrcContent pElem, HTransformParams pParams) {
        super(pElem);
        this.fTransform = pParams;
    }

    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcContent.TYPE) {
            return this;
        }
        if (pDefinition == ITransformAspect.TYPE) {
            return this;
        }
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition.canReadContent()) {
            return null;
        }
        return super.getAspectForThis(pDefinition);
    }

    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        IByteStream vStream = SrcFeatureTransform.transformContent(this.getSubSrcNode(), this.fTransform);
        return vStream != null ? vStream.getInputStream(true) : null;
    }

    public int getContentSize() throws Exception {
        if (this.fComputedSize == -1) {
            IByteStream vStream = SrcFeatureTransform.transformContent(this.getSubSrcNode(), this.fTransform);
            if (vStream != null) {
                OutputStreamCounter vCounter = new OutputStreamCounter();
                vStream.writeIn(vCounter);
                vStream.closeStream();
                this.fComputedSize = vCounter.getLength();
                return this.fComputedSize;
            }
            this.fComputedSize = -2;
        }
        return this.fComputedSize == -2 ? 0 : this.fComputedSize;
    }

    public IByteStream transform(HTransformParams pTransform) throws TransformContentException, Exception {
        HTransformParams vParams = this.fTransform.hClone(true);
        vParams.hAddNextTransformAtEnd(pTransform);
        return SrcFeatureTransform.transformContent(this.getSubSrcNode(), vParams);
    }

    public int getContentStatus() throws Exception {
        if (this.fComputedSize == -2) {
            return -1;
        }
        if (this.fComputedSize >= 0) {
            return 1;
        }
        return super.getContentStatus();
    }

    public final ISrcContent findContentByUri(String pUri) throws Exception {
        assert (pUri != null);
        if (pUri != null && pUri.length() == 0) {
            return this;
        }
        return ISrcContent.NULL;
    }
}

