/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.helpers.base.SrcNodeBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcNodeFrontEnd
extends SrcNodeBase
implements ISrcNode,
IRefreshAspect {
    protected ISrcServer fBackEndServer = null;
    protected ISrcContent fCachedSrcContent = null;

    public SrcNodeFrontEnd(ISrcServer pBackEndServer, String pUri) throws Exception {
        this.fBackEndServer = pBackEndServer;
        this.fUri = pUri;
        this.fCachedSrcContent = this.fBackEndServer.findContentByUri(this.fUri);
    }

    @Override
    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        Object vResult = super.getAspect(pDefinition);
        if (vResult != null) {
            return vResult;
        }
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition.isBijection()) {
            return null;
        }
        vResult = this.fCachedSrcContent.getAspect(pDefinition);
        if (vResult != null) {
            return vResult;
        }
        if (pDefinition.canReadContent() || pDefinition.canReadProperties() || pDefinition.canReadMeta()) {
            return null;
        }
        return this.fBackEndServer.getAspect(pDefinition);
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return this.fBackEndServer.findContentByUri(pUri);
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        return new SrcNodeFrontEnd(this.fBackEndServer, this.fUri + "/" + pChildName);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        return new SrcNodeFrontEnd(this.fBackEndServer, pUri);
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        List<String> vListContent = this.fCachedSrcContent.listChildrenNames(null, 0);
        if (vListContent == null) {
            return null;
        }
        if (vListContent.size() == 0) {
            return Collections.emptyList();
        }
        if (pListToAppend == null) {
            pListToAppend = new ArrayList<ISrcNode>(vListContent.size());
        }
        StringBuilder vSb = new StringBuilder(this.fUri.length() + 128);
        vSb.append(this.fUri);
        vSb.append('/');
        int vOffsetStartName = vSb.length();
        for (String vName : vListContent) {
            vSb.append(vName);
            pListToAppend.add(this.findNodeByUri(vSb.toString()));
            vSb.setLength(vOffsetStartName);
        }
        return pListToAppend;
    }

    @Override
    public boolean refresh() throws Exception {
        ISrcContent vNewContent = SrcFeatureRefresh.refreshContentFromServer(this.fBackEndServer, this.fUri, this.fCachedSrcContent);
        if (vNewContent == null) {
            return false;
        }
        this.fCachedSrcContent = vNewContent;
        return true;
    }

    @Override
    public boolean createAsFile() throws Exception {
        return this.fCachedSrcContent.createAsFile();
    }

    @Override
    public boolean createAsFolder() throws Exception {
        return this.fCachedSrcContent.createAsFolder();
    }

    @Override
    public int getContentSize() throws Exception {
        return this.fCachedSrcContent.getContentSize();
    }

    @Override
    public int getContentStatus() throws Exception {
        return this.fCachedSrcContent.getContentStatus();
    }

    @Override
    public String getContentType() throws Exception {
        return this.fCachedSrcContent.getContentType();
    }

    @Override
    public long getLastModif() throws Exception {
        return this.fCachedSrcContent.getLastModif();
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        return this.fCachedSrcContent.getLastModifWithChildren();
    }

    public List<String> listChildrenNames(List pListToAppend, int pStatusChildren) throws Exception {
        return this.fCachedSrcContent.listChildrenNames(pListToAppend, pStatusChildren);
    }

    @Override
    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        return this.fCachedSrcContent.newInputStream(pEnsureBuffered);
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        return this.fCachedSrcContent.newOutputStream(pEnsureBuffered);
    }

    @Override
    public boolean removeSrc() throws Exception {
        return this.fCachedSrcContent.removeSrc();
    }
}

