/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.NotAllowedException;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.rights.SrcFeatureRights;
import com.scenari.src.helpers.util.SrcContentRestrictRights;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrcNodeFrontEndRestrictRights
extends SrcNodeFrontEnd
implements IAccessRightsAspect {
    protected int fRightsAllowed = 511;

    public SrcNodeFrontEndRestrictRights(ISrcServer pBackEnd, String pUriBackEnd, int pRights) throws Exception {
        super(pBackEnd, pUriBackEnd);
        this.fRightsAllowed = pRights;
    }

    @Override
    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IAccessRightsAspect.TYPE) {
            return this;
        }
        Object vResult = super.getAspect(pDefinition);
        if (vResult != null) {
            if (SrcFeatureRights.isAllowed(this, pDefinition.rightsToCheck())) {
                return vResult;
            }
            throw new NotAllowedException();
        }
        return null;
    }

    @Override
    public ISrcContent findContentByUri(String pUri) throws Exception {
        return new SrcContentRestrictRights(this.fBackEndServer.findContentByUri(pUri), this.fRightsAllowed);
    }

    @Override
    public ISrcNode findNodeByUri(String pUri) throws Exception {
        return new SrcNodeFrontEndRestrictRights(this.fBackEndServer, pUri, this.fRightsAllowed);
    }

    @Override
    public ISrcNode findNodeChild(String pChildName) throws Exception {
        return new SrcNodeFrontEndRestrictRights(this.fBackEndServer, this.fUri + "/" + pChildName, this.fRightsAllowed);
    }

    @Override
    public int getRights() throws Exception {
        return this.fRightsAllowed;
    }

    @Override
    public List<ISrcNode> listChildrenNodes(List<ISrcNode> pListToAppend) throws Exception {
        if ((this.fRightsAllowed & 2) == 0) {
            throw new NotAllowedException();
        }
        return super.listChildrenNodes(pListToAppend);
    }

    @Override
    public InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        if ((this.fRightsAllowed & 1) == 0) {
            throw new NotAllowedException();
        }
        return super.newInputStream(pEnsureBuffered);
    }

    @Override
    public long getLastModifWithChildren() throws Exception {
        if ((this.fRightsAllowed & 1) == 0 || (this.fRightsAllowed & 2) == 0) {
            throw new NotAllowedException();
        }
        return super.getLastModifWithChildren();
    }

    @Override
    public long getLastModif() throws Exception {
        if ((this.fRightsAllowed & 1) == 0) {
            throw new NotAllowedException();
        }
        return super.getLastModif();
    }

    @Override
    public int getContentSize() throws Exception {
        if ((this.fRightsAllowed & 1) == 0) {
            throw new NotAllowedException();
        }
        return super.getContentSize();
    }

    @Override
    public String getContentType() throws Exception {
        if ((this.fRightsAllowed & 1) == 0) {
            throw new NotAllowedException();
        }
        return super.getContentType();
    }

    @Override
    public int getContentStatus() throws Exception {
        if ((this.fRightsAllowed & 1) == 0) {
            throw new NotAllowedException();
        }
        return super.getContentStatus();
    }

    public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
        if ((this.fRightsAllowed & 2) == 0) {
            throw new NotAllowedException();
        }
        return super.listChildrenNames(pListToAppend, pStatusChilds);
    }

    @Override
    public OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        if ((this.fRightsAllowed & 4) == 0) {
            throw new NotAllowedException();
        }
        if ((this.fRightsAllowed & 0x20) == 0 && this.fCachedSrcContent.getContentStatus() == -1) {
            throw new NotAllowedException();
        }
        return super.newOutputStream(pEnsureBuffered);
    }

    @Override
    public boolean createAsFile() throws Exception {
        if ((this.fRightsAllowed & 0x20) == 0) {
            throw new NotAllowedException();
        }
        return super.createAsFile();
    }

    @Override
    public boolean createAsFolder() throws Exception {
        if ((this.fRightsAllowed & 0x40) == 0) {
            throw new NotAllowedException();
        }
        return super.createAsFolder();
    }

    @Override
    public boolean removeSrc() throws Exception {
        if ((this.fRightsAllowed & 8) == 0) {
            throw new NotAllowedException();
        }
        return super.removeSrc();
    }
}

