/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.rights.IAccessRightsAspect;
import com.scenari.src.feature.uris.SrcFeatureUris;
import com.scenari.src.helpers.base.SrcContentFolderBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SrcServerMultiSources
implements ISrcServer {
    protected ServerEntry fBase = null;
    protected ArrayList<ServerEntry> fOverwrites = null;
    protected ArrayList<ServerEntry> fOverlays = null;
    protected boolean fOverlaysLocked = false;

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureRefresh.REFIND_SRCCONTENT_FOR_REFRESH && !this.fOverlaysLocked) {
            return Boolean.TRUE;
        }
        if (this.fBase != null) {
            return this.fBase.fServer.getAspect(pDefinition);
        }
        return null;
    }

    public void setBase(String pUri, ISrcServer pSrcServer) {
        if (pUri == null) {
            pUri = "";
        }
        this.fBase = new ServerEntry(pUri, pSrcServer);
    }

    public void addOverwrite(String pUri, ISrcServer pSrcServer) {
        if (pUri == null) {
            pUri = "";
        }
        if (this.fOverwrites == null) {
            this.fOverwrites = new ArrayList();
        }
        this.fOverwrites.add(new ServerEntry(pUri, pSrcServer));
    }

    public void addOverlay(String pUri, ISrcServer pSrcServer) {
        if (pUri == null) {
            pUri = "";
        }
        if (this.fOverlays == null) {
            this.fOverlays = new ArrayList();
        }
        this.fOverlays.add(new ServerEntry(pUri, pSrcServer));
    }

    public void setOverlaysLocked(boolean pOverlaysLocked) {
        this.fOverlaysLocked = pOverlaysLocked;
        if (pOverlaysLocked) {
            if (this.fOverlays != null) {
                this.fOverlays.trimToSize();
            }
            if (this.fOverwrites != null) {
                this.fOverwrites.trimToSize();
            }
        }
    }

    public ISrcContent findContentByUri(String pUri) throws Exception {
        int i;
        assert (pUri != null);
        if (pUri == null) {
            return ISrcContent.NULL;
        }
        ISrcContent vFolderSource = null;
        ISrcContent vFolderSourceNull = null;
        if (this.fOverwrites != null) {
            ServerEntry vLastOverwriteFound = null;
            int vLen = this.fOverwrites.size();
            for (int i2 = 0; i2 < vLen; ++i2) {
                ServerEntry vEntry = this.fOverwrites.get(i2);
                if (SrcFeatureUris.isAncestorOrSameUri(vEntry.fUri, pUri)) {
                    if (vLastOverwriteFound == null) {
                        vLastOverwriteFound = vEntry;
                        continue;
                    }
                    if (!SrcFeatureUris.isAncestorOrSameUri(vLastOverwriteFound.fUri, vEntry.fUri)) continue;
                    vLastOverwriteFound = vEntry;
                    continue;
                }
                if (!SrcFeatureUris.isAncestorOrSameUri(pUri, vEntry.fUri)) continue;
                vFolderSource = this.mergeAncestorFolder(vEntry, pUri, vFolderSource);
            }
            if (vLastOverwriteFound != null) {
                return vLastOverwriteFound.fServer.findContentByUri(pUri.substring(vLastOverwriteFound.fUri.length()));
            }
        }
        int vStop = this.fBase != null ? -1 : 0;
        int n = i = this.fOverlays != null ? this.fOverlays.size() - 1 : -1;
        while (i >= vStop) {
            ServerEntry vEntry;
            ServerEntry serverEntry = vEntry = i == -1 ? this.fBase : this.fOverlays.get(i);
            if (SrcFeatureUris.isAncestorOrSameUri(vEntry.fUri, pUri)) {
                ISrcContent vRes = vEntry.fServer.findContentByUri(pUri.substring(vEntry.fUri.length()));
                if (vRes != null) {
                    int vStatus = vRes.getContentStatus();
                    if (vStatus == 2) {
                        vFolderSource = vFolderSource == null ? vRes : new FolderBiSrcContent(vRes, vFolderSource);
                    } else if (vStatus == 1) {
                        if (vFolderSource == null) {
                            return vRes;
                        }
                    } else {
                        vFolderSourceNull = vRes;
                    }
                }
            } else if (SrcFeatureUris.isAncestorOrSameUri(pUri, vEntry.fUri)) {
                vFolderSource = this.mergeAncestorFolder(vEntry, pUri, vFolderSource);
            }
            --i;
        }
        return vFolderSource != null ? vFolderSource : (vFolderSourceNull != null ? vFolderSourceNull : ISrcContent.NULL);
    }

    protected ISrcContent mergeAncestorFolder(ServerEntry pEntry, String pUri, ISrcContent pFolderSource) throws Exception {
        int vStartName = pUri.length() + 1;
        int vIdxSlash = pEntry.fUri.indexOf(47, vStartName);
        FolderAncestorServer vFolderAnc = new FolderAncestorServer(pEntry.fUri.substring(vStartName, vIdxSlash < 0 ? pEntry.fUri.length() : vIdxSlash), vIdxSlash < 0 ? pEntry.fServer : null);
        if (pFolderSource == null) {
            return vFolderAnc;
        }
        return new FolderBiSrcContent(vFolderAnc, pFolderSource);
    }

    public static class FolderAncestorServer
    extends SrcContentFolderBase
    implements IAccessRightsAspect {
        protected String fChildName;
        protected ISrcServer fDirectChild;

        public FolderAncestorServer(String pChildName, ISrcServer pDirectChild) {
            this.fChildName = pChildName;
            this.fDirectChild = pDirectChild;
        }

        public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
            if (ISrcContent.TYPE == pDefinition) {
                return this;
            }
            if (IAccessRightsAspect.TYPE == pDefinition) {
                return this;
            }
            return null;
        }

        public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
            switch (pStatusChilds) {
                case 0: {
                    return this.appendToList(pListToAppend);
                }
                case 1: {
                    if (this.fDirectChild != null && this.fDirectChild.findContentByUri("").getContentStatus() == 1) {
                        return this.appendToList(pListToAppend);
                    }
                    return Collections.emptyList();
                }
                case 2: {
                    if (this.fDirectChild == null || this.fDirectChild.findContentByUri("").getContentStatus() == 2) {
                        return this.appendToList(pListToAppend);
                    }
                    return Collections.emptyList();
                }
            }
            throw new Exception("Status child unknown : " + pStatusChilds);
        }

        protected List appendToList(List pListToAppend) throws Exception {
            if (pListToAppend != null) {
                pListToAppend.add(this.fChildName);
                return pListToAppend;
            }
            return Collections.singletonList(this.fChildName);
        }

        public long getLastModif() throws Exception {
            return -1L;
        }

        public long getLastModifWithChildren() throws Exception {
            return -1L;
        }

        public int getRights() throws Exception {
            return 3;
        }
    }

    public static class FolderBiSrcContent
    extends SrcContentFolderBase
    implements IAccessRightsAspect {
        protected ISrcContent fBase = null;
        protected ISrcContent fOverlay = null;

        public FolderBiSrcContent(ISrcContent pBase, ISrcContent pOvelay) {
            this.fBase = pBase;
            this.fOverlay = pOvelay;
        }

        public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
            if (ISrcContent.TYPE == pDefinition) {
                return this;
            }
            if (IAccessRightsAspect.TYPE == pDefinition) {
                return this;
            }
            if (pDefinition.isBijection()) {
                return null;
            }
            Object vResult = this.fBase.getAspect(pDefinition);
            if (vResult == null) {
                this.fOverlay.getAspect(pDefinition);
            }
            return vResult;
        }

        public List listChildrenNames(List pListToAppend, int pStatusChilds) throws Exception {
            List<String> vListBase = this.fBase.listChildrenNames(null, pStatusChilds);
            List<String> vListOverlay = this.fOverlay.listChildrenNames(null, pStatusChilds);
            List<Object> vRes = pListToAppend != null ? pListToAppend : new ArrayList<String>(vListBase);
            int vOverlaySize = vListOverlay.size();
            for (int i = 0; i < vOverlaySize; ++i) {
                String vName = vListOverlay.get(i);
                if (vListBase.indexOf(vName) >= 0) continue;
                vRes.add(vName);
            }
            return vRes;
        }

        public long getLastModif() throws Exception {
            return Math.max(this.fBase.getLastModif(), this.fOverlay.getLastModif());
        }

        public long getLastModifWithChildren() throws Exception {
            return Math.max(this.fBase.getLastModifWithChildren(), this.fOverlay.getLastModifWithChildren());
        }

        public int getRights() throws Exception {
            return 3;
        }

        public String getContentType() throws Exception {
            return this.fBase.getContentType();
        }
    }

    public static class ServerEntry {
        protected String fUri = null;
        protected ISrcServer fServer = null;

        public ServerEntry(String pUri, ISrcServer pSource) {
            this.fUri = pUri;
            this.fServer = pSource;
        }

        public String toString() {
            return "<serverMultiSourceEntry uri='" + this.fUri + "'>" + this.fServer + "</serverMultiSourceEntry>";
        }
    }
}

