/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.walkers.ISrcFilterNode;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.OutputStreamByteStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipperSrc
extends OutputStreamByteStream {
    protected static final long EMPTY_CRC = 0L;
    protected ISrcNode fSource = null;
    protected String fRootFolder = null;
    protected ISrcFilterNode fFilter = null;

    public ZipperSrc() {
    }

    public ZipperSrc(ISrcNode pSource, String pRootFolder, ISrcFilterNode pFilter) {
        this.fSource = pSource;
        this.fRootFolder = pRootFolder;
        this.fFilter = pFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipSrcNode(ISrcNode pSource, ISrcFilterNode pFilter, OutputStream pStream) throws Exception {
        ZipOutputStream vZipOutput = new ZipOutputStream(pStream);
        try {
            this.fSource = pSource;
            this.fFilter = pFilter;
            String vPathRoot = "";
            if (this.fRootFolder != null) {
                vPathRoot = this.fRootFolder.concat("/");
                ZipEntry vEntry = new ZipEntry(vPathRoot);
                vEntry.setTime(pSource.getLastModif());
                vEntry.setSize(0L);
                vEntry.setMethod(0);
                vEntry.setCrc(0L);
                vZipOutput.putNextEntry(vEntry);
            }
            this.xZip(pSource, vZipOutput, vPathRoot);
        }
        finally {
            vZipOutput.finish();
        }
    }

    protected void xZip(ISrcNode pSource, ZipOutputStream pStream, String pParentPath) throws Exception {
        int vStatus = pSource.getContentStatus();
        if (vStatus == 1) {
            ZipEntry vEntry = new ZipEntry(pParentPath.concat(pSource.getSrcName()));
            vEntry.setTime(pSource.getLastModif());
            pStream.putNextEntry(vEntry);
            InputStream vIn = pSource.newInputStream(false);
            if (vIn != null) {
                StreamUtils.write(vIn, pStream);
            }
        } else if (vStatus == 2) {
            String vPath = pParentPath;
            if (pSource != this.fSource) {
                String vName = pSource.getSrcName();
                vPath = new StringBuilder(pParentPath.length() + vName.length() + 1).append(pParentPath).append(vName).append('/').toString();
                ZipEntry vEntry = new ZipEntry(vPath);
                vEntry.setTime(pSource.getLastModif());
                vEntry.setSize(0L);
                vEntry.setMethod(0);
                vEntry.setCrc(0L);
                pStream.putNextEntry(vEntry);
            }
            ArrayList<ISrcNode> vList = new ArrayList<ISrcNode>();
            pSource.listChildrenNodes(vList);
            for (int i = 0; i < vList.size(); ++i) {
                ISrcNode vCh = (ISrcNode)vList.get(i);
                if (this.fFilter != null && !this.fFilter.isNodeAccepted(vCh)) continue;
                this.xZip(vCh, pStream, vPath);
            }
        }
    }

    public void writeIn(OutputStream pStream) throws Exception {
        this.zipSrcNode(this.fSource, this.fFilter, pStream);
    }

    public void setSrcNode(ISrcNode pSource) {
        this.fSource = pSource;
    }

    public void setRootFolderName(String pRootFolderName) {
        this.fRootFolder = pRootFolderName;
    }

    public void setSrcFilterNode(ISrcFilterNode pFilter) {
        this.fFilter = pFilter;
    }
}

