/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.util;

import com.scenari.src.ISrcNode;
import com.scenari.src.helpers.util.ZipperSrc;
import com.scenari.src.helpers.walkers.ISrcFilterNode;
import eu.scenari.fw.stream.StreamUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipperSrcFreeEncoding
extends ZipperSrc {
    public static String sFileNameEncoding = "Cp437";
    protected String fFileNameEncoding = sFileNameEncoding;

    public ZipperSrcFreeEncoding() {
    }

    public ZipperSrcFreeEncoding(ISrcNode pSource, String pRootFolder, ISrcFilterNode pFilter) {
        super(pSource, pRootFolder, pFilter);
    }

    public ZipperSrcFreeEncoding(ISrcNode pSource, String pRootFolder, ISrcFilterNode pFilter, String pNameEncoding) {
        super(pSource, pRootFolder, pFilter);
        this.fFileNameEncoding = pNameEncoding;
    }

    public String getFileNameEncoding() {
        return this.fFileNameEncoding;
    }

    public void setFileNameEncoding(String pFileNameEncoding) {
        this.fFileNameEncoding = pFileNameEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipSrcNode(ISrcNode pSource, ISrcFilterNode pFilter, OutputStream pStream) throws Exception {
        ZipOutputStream vZipOutput = new ZipOutputStream(pStream);
        vZipOutput.setEncoding(this.fFileNameEncoding);
        try {
            this.fSource = pSource;
            this.fFilter = pFilter;
            String vPathRoot = "";
            if (this.fRootFolder != null) {
                vPathRoot = this.fRootFolder.concat("/");
                ZipEntry vEntry = new ZipEntry(vPathRoot);
                vEntry.setTime(pSource.getLastModif());
                vEntry.setSize(0L);
                vEntry.setMethod(0);
                vEntry.setCrc(0L);
                vZipOutput.putNextEntry(vEntry);
            }
            this.xZip(pSource, vZipOutput, vPathRoot);
        }
        finally {
            vZipOutput.finish();
        }
    }

    protected void xZip(ISrcNode pSource, ZipOutputStream pStream, String pParentPath) throws Exception {
        int vStatus = pSource.getContentStatus();
        if (vStatus == 1) {
            ZipEntry vEntry = new ZipEntry(pParentPath.concat(pSource.getSrcName()));
            vEntry.setTime(pSource.getLastModif());
            pStream.putNextEntry(vEntry);
            InputStream vIn = pSource.newInputStream(false);
            if (vIn != null) {
                StreamUtils.write(vIn, (OutputStream)pStream);
            }
        } else if (vStatus == 2) {
            String vPath = pParentPath;
            if (pSource != this.fSource) {
                String vName = pSource.getSrcName();
                vPath = new StringBuilder(pParentPath.length() + vName.length() + 1).append(pParentPath).append(vName).append('/').toString();
                ZipEntry vEntry = new ZipEntry(vPath);
                vEntry.setTime(pSource.getLastModif());
                vEntry.setSize(0L);
                vEntry.setMethod(0);
                vEntry.setCrc(0L);
                pStream.putNextEntry(vEntry);
            }
            ArrayList<ISrcNode> vList = new ArrayList<ISrcNode>();
            pSource.listChildrenNodes(vList);
            for (int i = 0; i < vList.size(); ++i) {
                ISrcNode vCh = (ISrcNode)vList.get(i);
                if (this.fFilter != null && !this.fFilter.isNodeAccepted(vCh)) continue;
                this.xZip(vCh, pStream, vPath);
            }
        }
    }
}

