/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.helpers.walkers;

import com.scenari.s.fw.utils.HIntArrayList;
import com.scenari.src.ISrcNode;
import java.util.ArrayList;
import java.util.List;

public class SrcIteratorNode {
    protected ISrcNode fRoot = null;
    protected ISrcNode fCurrent = null;
    protected List<List<ISrcNode>> fStackSiblings = new ArrayList<List<ISrcNode>>();
    protected HIntArrayList fStackOffsets = new HIntArrayList();

    public SrcIteratorNode() {
    }

    public SrcIteratorNode(ISrcNode pRoot) {
        this.fRoot = pRoot;
        this.fCurrent = pRoot;
    }

    public void reset(ISrcNode pNewRoot) {
        this.fRoot = pNewRoot;
        this.fCurrent = pNewRoot;
        this.fStackSiblings.clear();
        this.fStackOffsets.clear();
    }

    public ISrcNode getCurrentNode() {
        return this.fCurrent;
    }

    public ISrcNode nextNode() throws Exception {
        ISrcNode vResult = this.firstChild();
        if (vResult != null) {
            return vResult;
        }
        vResult = this.nextSibling();
        if (vResult != null) {
            return vResult;
        }
        vResult = this.nextUncle();
        if (vResult != null) {
            return vResult;
        }
        return null;
    }

    public ISrcNode firstChild() throws Exception {
        List<ISrcNode> vList = this.fCurrent.listChildrenNodes(null);
        if (vList != null && vList.size() > 0) {
            this.fCurrent = vList.get(0);
            this.fStackSiblings.add(vList);
            this.fStackOffsets.addInt(0);
            return this.fCurrent;
        }
        return null;
    }

    public ISrcNode nextSibling() throws Exception {
        int vStackDepth = this.fStackSiblings.size() - 1;
        if (vStackDepth >= 0) {
            int vNextOffset = this.fStackOffsets.getInt(vStackDepth) + 1;
            List<ISrcNode> vSiblings = this.fStackSiblings.get(vStackDepth);
            if (vSiblings.size() > vNextOffset) {
                this.fCurrent = vSiblings.get(vNextOffset);
                this.fStackOffsets.setInt(vStackDepth, vNextOffset);
                return this.fCurrent;
            }
        }
        return null;
    }

    public ISrcNode nextUncle() throws Exception {
        ISrcNode vParent = this.gotoParent();
        while (vParent != null) {
            ISrcNode vNextSibling = this.nextSibling();
            if (vNextSibling != null) {
                return vNextSibling;
            }
            vParent = this.gotoParent();
        }
        return null;
    }

    public ISrcNode nextSiblingOrUncle() throws Exception {
        ISrcNode vResult = this.nextSibling();
        if (vResult != null) {
            return vResult;
        }
        vResult = this.nextUncle();
        if (vResult != null) {
            return vResult;
        }
        return null;
    }

    public ISrcNode gotoParent() throws Exception {
        int vStackDepth = this.fStackSiblings.size() - 1;
        if (vStackDepth >= 0) {
            this.fStackSiblings.remove(vStackDepth);
            this.fStackOffsets.remove(vStackDepth);
            if (vStackDepth == 0) {
                this.fCurrent = this.fRoot;
            } else {
                int vCurrentOffset = this.fStackOffsets.getInt(--vStackDepth);
                this.fCurrent = this.fStackSiblings.get(vStackDepth).get(vCurrentOffset);
            }
            return this.fCurrent;
        }
        return null;
    }
}

