/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.exp;

import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.func.ImmutableFunc;
import com.scenari.src.search.func.VarFunc;
import com.scenari.src.search.helpers.base.ExpBase;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.syntax.json.IJsonisable;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.fw.util.xml.IFragmentSaxHandler;
import java.util.List;
import org.xml.sax.Attributes;

public class FullText
extends ExpBase {
    public static String ID = "com.scenari.src.search.exp.FullText";
    public static final String DATAKEY_FULLTEXTRESULTS = "fullText_results";
    public static final String DATAKEY_FULLTEXTSCORE = "fullText_score";
    protected ISearchFunction fRawTextSearch = null;

    public String getIdExp() {
        return ID;
    }

    public ISearchFunction getRawTextSearch() {
        return this.fRawTextSearch;
    }

    public void setRawTextSearch(ISearchFunction pRawTextSearch) {
        this.fRawTextSearch = pRawTextSearch;
    }

    public IFragmentSaxHandler initFromXml(Attributes pAtts) throws Exception {
        String vText = pAtts.getValue("textSearch");
        if (vText != null) {
            this.fRawTextSearch = new ImmutableFunc(vText);
        } else {
            String vPathVar = pAtts.getValue("pathVar");
            if (vPathVar != null) {
                this.fRawTextSearch = new VarFunc(vText);
            } else {
                throw new Exception("Syntax error in FullText expression : no textSearch nor textSearchVar attribute.");
            }
        }
        return null;
    }

    static {
        FieldsCollectorBuilder.declareDataKey(DATAKEY_FULLTEXTRESULTS);
        FieldsCollectorBuilder.declareDataKey(DATAKEY_FULLTEXTSCORE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FullTextResults
    implements IJsonisable {
        protected int fScore = 1;
        protected List<String> fPreviews = null;

        public int getScore() {
            return this.fScore;
        }

        public List<String> getPreviews() {
            return this.fPreviews;
        }

        public void setScore(int pScore) {
            this.fScore = pScore;
        }

        public void setPreviews(List<String> pPreviews) {
            this.fPreviews = pPreviews;
        }

        @Override
        public void writeJson(JsonSerializer pJson) throws Exception {
            pJson.startObject();
            pJson.key("score");
            pJson.valNumber(this.fScore);
            if (this.fPreviews != null) {
                pJson.key("previews");
                pJson.startArray();
                for (String vPreview : this.fPreviews) {
                    pJson.valString(vPreview);
                }
                pJson.endArray();
            }
            pJson.endObject();
        }

        public String toString() {
            try {
                StringBuilder vSb = new StringBuilder(20 + (this.fPreviews != null ? this.fPreviews.size() * 50 : 0));
                JsonSerializer vJson = new JsonSerializer(vSb);
                this.writeJson(vJson);
                return vSb.toString();
            }
            catch (Exception e) {
                LogMgr.publishException((Throwable)e, "Json serialisation failed.", new String[0]);
                return "{}";
            }
        }
    }
}

