/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.helpers.util;

import com.scenari.src.search.StopIterate;
import eu.scenari.fw.util.collections.IteratorBufferedNextBase;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeFilterIterator<E>
extends IteratorBufferedNextBase<E> {
    protected Iterator<? extends E> fSource;
    protected StorageSource fSourceIt = null;
    protected Iterator<E> fFilter;
    protected E[] fStorage = null;
    protected int fStorageFirstIdx = 0;
    protected int fStorageEndIdx = 0;
    protected int fStorageCount = 0;
    protected int fStorageCountMax;
    protected int fLastIdxFound = -1;
    protected StopIterate fStopIterate = null;

    public ExcludeFilterIterator(Iterator<? extends E> pSourceIterator, int pStorageCapacity) {
        this.fSource = pSourceIterator;
        this.fSourceIt = new StorageSource(this.fSource);
        this.fStorage = new Object[pStorageCapacity + 1];
        this.fStorageCountMax = pStorageCapacity;
    }

    public Iterator<E> getWrappedSourceIterator() {
        return this.fSourceIt;
    }

    public void setFilterIterator(Iterator<E> pFilter) {
        this.fFilter = pFilter;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        if (this.fNext != null) {
            return true;
        }
        block0: while (true) {
            if (this.fLastIdxFound == -2) {
                if (this.fStorageCount > 0) {
                    this.fNext = this.fStorage[this.fStorageFirstIdx];
                    this.cleanStorageFirstIdx();
                    return true;
                }
                return false;
            }
            if (this.fLastIdxFound != -1) {
                if (this.fLastIdxFound != this.fStorageFirstIdx) {
                    this.fNext = this.fStorage[this.fStorageFirstIdx];
                    this.cleanStorageFirstIdx();
                    return true;
                }
                this.cleanStorageFirstIdx();
            }
            if (this.searchNextEntry()) continue;
            while (true) {
                if (this.fStorageCount > 0) ** break;
                continue block0;
                this.cleanStorageFirstIdx();
            }
            break;
        }
    }

    protected void cleanStorageFirstIdx() {
        int vOldFirstIdx = this.fStorageFirstIdx++;
        this.fStorage[vOldFirstIdx] = null;
        --this.fStorageCount;
        if (this.fStorageFirstIdx == this.fStorage.length) {
            this.fStorageFirstIdx = 0;
        }
        if (this.fLastIdxFound == vOldFirstIdx) {
            this.fLastIdxFound = -1;
        }
    }

    protected boolean searchNextEntry() {
        try {
            this.fLastIdxFound = this.fFilter.hasNext() ? this.getStorageIdxFromEntry(this.fFilter.next()) : -2;
            return true;
        }
        catch (StopIterate vStopIt) {
            if (vStopIt.getOwner() != this) {
                throw vStopIt;
            }
            return false;
        }
    }

    protected int getStorageIdxFromEntry(E pEntry) {
        int i;
        int vEnd = Math.min(this.fStorageFirstIdx + this.fStorageCount, this.fStorage.length);
        for (i = this.fStorageFirstIdx; i < vEnd; ++i) {
            if (!this.isEntriesEquals(pEntry, this.fStorage[i])) continue;
            return i;
        }
        if (this.fStorageCount > 0 && this.fStorageEndIdx <= this.fStorageFirstIdx) {
            for (i = 0; i < this.fStorageEndIdx; ++i) {
                if (!this.isEntriesEquals(pEntry, this.fStorage[i])) continue;
                return i;
            }
        }
        throw new IndexOutOfBoundsException("Entry not found in StorageSource " + pEntry);
    }

    protected boolean isEntriesEquals(E pE1, E pE2) {
        return pE1 == pE2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StorageSource
    implements Iterator<E> {
        public StorageSource(Iterator<? extends E> pSource) {
            ExcludeFilterIterator.this.fSource = pSource;
        }

        @Override
        public boolean hasNext() {
            this.checkSpace();
            return ExcludeFilterIterator.this.fSource.hasNext();
        }

        @Override
        public E next() {
            this.checkSpace();
            Object vNext = ExcludeFilterIterator.this.fSource.next();
            ExcludeFilterIterator.this.fStorage[ExcludeFilterIterator.this.fStorageEndIdx++] = vNext;
            if (ExcludeFilterIterator.this.fStorageEndIdx == ExcludeFilterIterator.this.fStorage.length) {
                ExcludeFilterIterator.this.fStorageEndIdx = 0;
            }
            ++ExcludeFilterIterator.this.fStorageCount;
            return vNext;
        }

        protected void checkSpace() {
            if (ExcludeFilterIterator.this.fStorageCount == ExcludeFilterIterator.this.fStorageCountMax) {
                if (ExcludeFilterIterator.this.fStopIterate == null) {
                    ExcludeFilterIterator.this.fStopIterate = new StopIterate(ExcludeFilterIterator.this);
                }
                throw ExcludeFilterIterator.this.fStopIterate;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation not supported.");
        }
    }
}

