/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.helpers.util;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.FieldsCollector;
import com.scenari.src.feature.fields.SrcFeatureFields;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchRequestCompiled;
import com.scenari.src.search.ISearchResultRow;

public class ResultRow
extends FieldsCollector
implements ISearchResultRow.ISearchResultRowInternal {
    protected String fUri;
    protected ISearchContext.ISearchContextInternal fContext;

    public ResultRow(String pUri, ISearchContext.ISearchContextInternal pContext) {
        super(((ISearchRequestCompiled.ISearchRequestCompiledInternal)pContext.getRequest()).getDataKeys());
        this.fUri = pUri;
        this.fContext = pContext;
    }

    public String getRowUri() {
        return this.fUri;
    }

    public ISrcContent getSrcContent() throws Exception {
        return this.fContext.getSrcFrom().findContentByUri(this.fUri);
    }

    public ISrcNode getSrcNode() throws Exception {
        ISrcNode vNode = this.fContext.getSrcFrom().getAspect(ISrcNode.TYPE);
        vNode = vNode == null ? new SrcNodeFrontEnd(this.fContext.getSrcFrom(), this.fUri) : vNode.findNodeByUri(this.fUri);
        return vNode;
    }

    public ISearchContext getContext() {
        return this.fContext;
    }

    public Object getColumnValue(String pName) throws Exception {
        int vIdxCol = this.fContext.getRequest().getColumnNames().indexOf(pName);
        if (vIdxCol > 0) {
            return this.getColumnValue(vIdxCol);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getColumnValue(int pIdxCol) throws Exception {
        ISearchFunction vFunction = this.fContext.getRequest().getColumnFunction(pIdxCol);
        this.fContext.pushCurrentRow(this);
        Object vResult = null;
        try {
            vResult = vFunction.evaluate(this.fContext);
        }
        finally {
            this.fContext.popCurrentRow();
        }
        return vResult;
    }

    public Object getData(String pDataKey) throws Exception {
        if (pDataKey == this.fItDataKey) {
            Object vValue = this.fDatas[this.fItIdx];
            return vValue == NULLVALUE ? null : (vValue == null ? this.fillDefaultDatas(pDataKey) : vValue);
        }
        int len = this.fDataKeys.length;
        for (int i = 0; i < len; ++i) {
            if (this.fDataKeys[i] != pDataKey) continue;
            Object vValue = this.fDatas[i];
            return vValue == NULLVALUE ? null : (vValue == null ? this.fillDefaultDatas(pDataKey) : vValue);
        }
        return null;
    }

    protected Object fillDefaultDatas(String pDataKey) throws Exception {
        SrcFeatureFields.fillFields(this.getSrcNode(), this);
        int len = this.fDatas.length;
        for (int i = 0; i < len; ++i) {
            if (this.fDatas[i] != null) continue;
            this.fDatas[i] = NULLVALUE;
        }
        return super.getData(pDataKey);
    }
}

