/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.helpers.util;

import com.scenari.src.search.StopIterate;
import eu.scenari.fw.util.collections.IteratorBufferedNextBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFiltersIterator<E>
extends IteratorBufferedNextBase<E> {
    protected Comparator<? super E> fComparator = null;
    protected Iterator<? extends E> fSource;
    protected Iterator<E>[] fFilters;
    protected int[] fLastIdxFound;
    protected E[] fStorage = null;
    protected int fStorageFirstIdx = 0;
    protected int fStorageEndIdx = 0;
    protected int fStorageCount = 0;
    protected int fStorageCountMax;
    protected boolean[] fFoundEntries = null;
    protected List<StorageSource> fListSourcesIt = new ArrayList<StorageSource>();
    protected StopIterate fStopIterate = null;

    public UnionFiltersIterator(Iterator<? extends E> pSourceIterator, int pStorageCapacity, Comparator<? super E> pComparator) {
        this.fComparator = pComparator;
        this.fSource = pSourceIterator;
        this.fStorage = new Object[pStorageCapacity + 1];
        this.fFoundEntries = new boolean[pStorageCapacity + 1];
        this.fStorageCountMax = pStorageCapacity;
    }

    public Iterator<E> wrapSourceIterator() {
        StorageSource vNew = new StorageSource(this.fSource);
        this.fListSourcesIt.add(vNew);
        return vNew;
    }

    public void setFiltersIterator(Iterator<E>[] pFilters, int pCount) {
        this.fFilters = pFilters;
        this.fLastIdxFound = new int[pCount];
        Arrays.fill(this.fLastIdxFound, -1);
    }

    @Override
    public boolean hasNext() {
        if (this.fNext != null) {
            return true;
        }
        while (true) {
            if (this.fFoundEntries[this.fStorageFirstIdx]) {
                this.fNext = this.fStorage[this.fStorageFirstIdx];
                this.cleanStorageFirstIdx();
                return true;
            }
            boolean vAllFiltersOk = true;
            for (int vIdxFiler = 0; vIdxFiler < this.fLastIdxFound.length; ++vIdxFiler) {
                if (this.fLastIdxFound[vIdxFiler] != -1) continue;
                vAllFiltersOk = false;
                break;
            }
            if (vAllFiltersOk) {
                while (this.fStorageCount > 0 && !this.fFoundEntries[this.fStorageFirstIdx]) {
                    this.cleanStorageFirstIdx();
                }
                if (this.fStorageCount == 0) {
                    return false;
                }
                this.fNext = this.fStorage[this.fStorageFirstIdx];
                this.cleanStorageFirstIdx();
                return true;
            }
            if (this.searchEntries()) continue;
            while (this.fStorageCount > 0 && !this.fFoundEntries[this.fStorageFirstIdx]) {
                this.cleanStorageFirstIdx();
            }
            if (this.fStorageCount != 0) break;
        }
        this.fNext = this.fStorage[this.fStorageFirstIdx];
        this.cleanStorageFirstIdx();
        return true;
    }

    protected void cleanStorageFirstIdx() {
        int vOldFirstIdx = this.fStorageFirstIdx;
        this.fStorage[vOldFirstIdx] = null;
        this.fFoundEntries[vOldFirstIdx] = false;
        for (int i = 0; i < this.fLastIdxFound.length; ++i) {
            if (this.fLastIdxFound[i] != vOldFirstIdx) continue;
            this.fLastIdxFound[i] = -1;
        }
        ++this.fStorageFirstIdx;
        --this.fStorageCount;
        if (this.fStorageFirstIdx == this.fStorage.length) {
            this.fStorageFirstIdx = 0;
        }
        for (StorageSource vStorIt : this.fListSourcesIt) {
            if (vStorIt.fCurrentIdx != vOldFirstIdx) continue;
            vStorIt.fCurrentIdx = this.fStorageFirstIdx;
        }
    }

    protected boolean searchEntries() {
        boolean vAtLeastOneChange = false;
        for (int vFilterIdx = 0; vFilterIdx < this.fLastIdxFound.length; ++vFilterIdx) {
            if (this.fLastIdxFound[vFilterIdx] != -1) continue;
            try {
                Iterator<E> vIt = this.fFilters[vFilterIdx];
                if (vIt.hasNext()) {
                    int vIdxEntry = this.getStorageIdxFromEntry(vIt.next());
                    if (vIdxEntry < 0) continue;
                    this.fFoundEntries[vIdxEntry] = true;
                    this.fLastIdxFound[vFilterIdx] = vIdxEntry;
                    if (vAtLeastOneChange) continue;
                    vAtLeastOneChange = true;
                    continue;
                }
                this.fLastIdxFound[vFilterIdx] = -2;
                if (vAtLeastOneChange) continue;
                vAtLeastOneChange = true;
                continue;
            }
            catch (StopIterate vStopIt) {
                if (vStopIt.getOwner() == this) continue;
                throw vStopIt;
            }
        }
        return vAtLeastOneChange;
    }

    protected int getStorageIdxFromEntry(E pEntry) {
        int i;
        int vEnd = Math.min(this.fStorageFirstIdx + this.fStorageCount, this.fStorage.length);
        for (i = this.fStorageFirstIdx; i < vEnd; ++i) {
            if (!this.isEntriesEquals(pEntry, this.fStorage[i])) continue;
            return i;
        }
        if (this.fStorageCount > 0 && this.fStorageEndIdx <= this.fStorageFirstIdx) {
            for (i = 0; i < this.fStorageEndIdx; ++i) {
                if (!this.isEntriesEquals(pEntry, this.fStorage[i])) continue;
                return i;
            }
        }
        return -1;
    }

    protected boolean isEntriesEquals(E pE1, E pE2) {
        if (this.fComparator != null) {
            return this.fComparator.compare(pE1, pE2) == 0;
        }
        return pE1.equals(pE2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StorageSource
    implements Iterator<E> {
        protected int fCurrentIdx = 0;

        public StorageSource(Iterator<? extends E> pSource) {
            UnionFiltersIterator.this.fSource = pSource;
        }

        @Override
        public boolean hasNext() {
            if (this.fCurrentIdx != UnionFiltersIterator.this.fStorageEndIdx) {
                return true;
            }
            this.checkSpace();
            return UnionFiltersIterator.this.fSource.hasNext();
        }

        @Override
        public E next() {
            while (true) {
                if (this.fCurrentIdx == UnionFiltersIterator.this.fStorageEndIdx) {
                    this.checkSpace();
                    Object vNext = UnionFiltersIterator.this.fSource.next();
                    UnionFiltersIterator.this.fStorage[UnionFiltersIterator.this.fStorageEndIdx++] = vNext;
                    ++this.fCurrentIdx;
                    if (UnionFiltersIterator.this.fStorageEndIdx == UnionFiltersIterator.this.fStorage.length) {
                        UnionFiltersIterator.this.fStorageEndIdx = 0;
                        this.fCurrentIdx = 0;
                    }
                    ++UnionFiltersIterator.this.fStorageCount;
                    return vNext;
                }
                if (!UnionFiltersIterator.this.fFoundEntries[this.fCurrentIdx]) {
                    Object vNext = UnionFiltersIterator.this.fStorage[this.fCurrentIdx++];
                    if (this.fCurrentIdx == UnionFiltersIterator.this.fStorage.length) {
                        this.fCurrentIdx = 0;
                    }
                    return vNext;
                }
                if (++this.fCurrentIdx != UnionFiltersIterator.this.fStorage.length) continue;
                this.fCurrentIdx = 0;
            }
        }

        protected void checkSpace() {
            if (UnionFiltersIterator.this.fStorageCount == UnionFiltersIterator.this.fStorageCountMax) {
                if (UnionFiltersIterator.this.fStopIterate == null) {
                    UnionFiltersIterator.this.fStopIterate = new StopIterate(UnionFiltersIterator.this);
                }
                throw UnionFiltersIterator.this.fStopIterate;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation not supported.");
        }
    }
}

