/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.impl;

import com.scenari.src.ISrcServer;
import com.scenari.src.feature.paths.ISrcAliasResolver;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchRequestCompiled;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.impl.RequestCompiled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context
implements ISearchContext.ISearchContextInternal {
    protected RequestCompiled fRequest = null;
    protected ISrcAliasResolver fAliasResolver = null;
    protected Map<String, Object> fMapVariables = null;
    protected List<ISearchResultRow.ISearchResultRowInternal> fStackCurrentRow = new ArrayList<ISearchResultRow.ISearchResultRowInternal>();

    public Context(RequestCompiled pReq) {
        this.fRequest = pReq;
    }

    public ISearchRequestCompiled getRequest() {
        return this.fRequest;
    }

    public ISrcAliasResolver getAliasResolver() {
        return this.fAliasResolver;
    }

    public ISrcServer getSrcFrom() {
        return this.fRequest.getSrcFrom();
    }

    public Object getVariableValue(String pKey) {
        if (this.fMapVariables == null || pKey == null) {
            return null;
        }
        return this.fMapVariables.get(pKey);
    }

    public void setAliasResolver(ISrcAliasResolver pResolver) {
        this.fAliasResolver = pResolver;
    }

    public void setVariableValue(String pKey, Object pValue) {
        if (this.fMapVariables == null) {
            this.fMapVariables = new HashMap<String, Object>();
        }
        this.fMapVariables.put(pKey, pValue);
    }

    public Object getDataInCurrentRow(String pKeyData) throws Exception {
        int vStackSize = this.fStackCurrentRow.size();
        if (vStackSize > 0) {
            ISearchResultRow.ISearchResultRowInternal vRow = this.fStackCurrentRow.get(vStackSize - 1);
            return vRow.getData(pKeyData);
        }
        return null;
    }

    public void popCurrentRow() {
        this.fStackCurrentRow.remove(this.fStackCurrentRow.size() - 1);
    }

    public void pushCurrentRow(ISearchResultRow.ISearchResultRowInternal pRow) {
        this.fStackCurrentRow.add(pRow);
    }

    public String resolvePath2Uri(String pPath) throws Exception {
        String vUri = "";
        int vStackSize = this.fStackCurrentRow.size();
        if (vStackSize > 0) {
            vUri = this.fStackCurrentRow.get(vStackSize - 1).getRowUri();
        }
        return SrcFeaturePaths.findUriByPath(this.getSrcFrom(), pPath, vUri, false);
    }
}

