/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.impl;

import com.scenari.src.ISrcServer;
import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchExp;
import com.scenari.src.search.ISearchFunction;
import com.scenari.src.search.ISearchRequest;
import com.scenari.src.search.ISearchRequestCompiled;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.And;
import com.scenari.src.search.exp.Not;
import com.scenari.src.search.exp.Or;
import com.scenari.src.search.helpers.util.ResultRowCount;
import com.scenari.src.search.impl.Context;
import com.scenari.src.search.impl.DefaultExecutor;
import com.scenari.src.search.impl.execexp.AndExecExp;
import com.scenari.src.search.impl.execexp.NotExecExp;
import com.scenari.src.search.impl.execexp.OrExecExp;
import com.scenari.src.search.impl.execexp.RootFolderExecExp;
import eu.scenari.fw.util.collections.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCompiled
implements ISearchRequestCompiled.ISearchRequestCompiledInternal {
    protected static final String[] EMPTY_STR_ARRAY = new String[0];
    protected int fMaxResults;
    protected ISearchRequest.ResultType fResultType;
    protected List<String> fColumnNames = Collections.emptyList();
    protected ISearchFunction[] fColumnFunctions = null;
    protected ISrcServer fSrcFrom = null;
    protected ISearchExecutableExp fMainExecExp = null;
    protected String[] fDataKeys = EMPTY_STR_ARRAY;

    public RequestCompiled(ISearchRequest pFromRequest, ISrcServer pSrcFrom) {
        this.fResultType = pFromRequest.getResultType();
        this.fMaxResults = pFromRequest.getMaxResults();
        List<String> vCols = pFromRequest.getColumnNames();
        if (vCols.size() > 0) {
            this.fColumnNames = new ArrayList<String>(vCols);
            this.fColumnFunctions = new ISearchFunction[this.fColumnNames.size()];
            for (int i = 0; i < this.fColumnFunctions.length; ++i) {
                this.fColumnFunctions[i] = pFromRequest.getColumnFunction(i);
            }
        }
        this.fSrcFrom = pSrcFrom;
    }

    @Override
    public ISearchExp getMainExpression() {
        return null;
    }

    @Override
    public ISearchRequest.ResultType getResultType() {
        return this.fResultType;
    }

    @Override
    public List<String> getColumnNames() {
        return this.fColumnNames;
    }

    @Override
    public ISearchFunction getColumnFunction(int pColumn) {
        return this.fColumnFunctions[pColumn];
    }

    @Override
    public int getMaxResults() {
        return this.fMaxResults;
    }

    @Override
    public ISearchContext newContext() throws Exception {
        return new Context(this);
    }

    @Override
    public Iterator<ISearchResultRow> execute(ISearchContext pContext) throws Exception {
        if (pContext == null) {
            pContext = new Context(this);
        }
        switch (this.fResultType) {
            case entries: {
                Iterator<ISearchResultRow> vItResult = this.fMainExecExp.search((ISearchContext.ISearchContextInternal)pContext);
                if (this.fMaxResults > 0) {
                    return new MaxResultsIterator(vItResult);
                }
                return vItResult;
            }
            case count: {
                Iterator<ISearchResultRow.ISearchResultRowInternal> vIt = this.fMainExecExp.search((ISearchContext.ISearchContextInternal)pContext);
                int vResult = 0;
                while (vIt.hasNext()) {
                    ++vResult;
                    vIt.next();
                }
                ResultRowCount vRow = new ResultRowCount(pContext, vResult);
                return CollectionUtil.newSingletonIterator(vRow);
            }
        }
        throw new AssertionError((Object)"ResultType uknown");
    }

    public ISrcServer getSrcFrom() {
        return this.fSrcFrom;
    }

    @Override
    public String[] getDataKeys() {
        return this.fDataKeys;
    }

    protected ISearchExecutor getDefaultExecutor() {
        return DefaultExecutor.DEFAULT_IMPL;
    }

    public void compile(ISearchRequest pFromRequest, List<ISearchExecutor> pExecutors) throws Exception {
        MakeExecutableExpContext vMakeContext = new MakeExecutableExpContext();
        ISearchExp vMainExp = pFromRequest.getMainExpression();
        if (pExecutors.size() > 0) {
            pExecutors.add(this.getDefaultExecutor());
            if (this.isBooleanExp(vMainExp)) {
                IdentityHashMap<ISearchExp, ISearchExecutableExp> vMapExpLeaf = new IdentityHashMap<ISearchExp, ISearchExecutableExp>();
                vMainExp.acceptExpVisitor(new MakeExecExpLeaf(vMapExpLeaf, pExecutors, vMakeContext));
                vMakeContext.fMapExpLeaf = vMapExpLeaf;
                this.fMainExecExp = this.makeExecBooleanExp(vMainExp, pExecutors, vMakeContext);
            } else {
                this.fMainExecExp = this.makeExecLeafExp(vMainExp, pExecutors, vMakeContext);
            }
        } else {
            this.fMainExecExp = this.getDefaultExecutor().makeExecutableExp(vMainExp, vMakeContext);
            if (this.fMainExecExp == null) {
                throw new Exception("No executor found for : " + vMainExp);
            }
        }
        if (!this.fMainExecExp.isSearchable()) {
            AndExecExp vAndWrapper = new AndExecExp(this.getDefaultExecutor());
            ISearchExecutableExp[] vMembers = new ISearchExecutableExp[]{new RootFolderExecExp(this.getDefaultExecutor()), this.fMainExecExp};
            vAndWrapper.init(vMembers);
            this.fMainExecExp = vAndWrapper;
        }
        if (pFromRequest.getColumnNames().size() > 0) {
            int i;
            HashSet<String> vDataKeys = new HashSet<String>();
            for (i = 0; i < this.fColumnFunctions.length; ++i) {
                this.fColumnFunctions[i].listDataToProvide(vDataKeys);
            }
            if (vDataKeys.size() > 0) {
                this.fDataKeys = vDataKeys.toArray(new String[vDataKeys.size()]);
                for (i = 0; i < this.fDataKeys.length; ++i) {
                    this.fMainExecExp.provideData(this.fDataKeys[i]);
                }
            }
        }
        this.fMainExecExp.compile(ISearchExecutableExp.ExecMode.search);
    }

    protected ISearchExecutableExp makeExecLeafExp(ISearchExp pExp, List<ISearchExecutor> pExecutors, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        ISearchExecutableExp vResult = null;
        ArrayList<ISearchExecutableExp> vExpToCoalesce = null;
        block0: for (ISearchExecutor vSearchExecutor : pExecutors) {
            ISearchExecutableExp vExecExp = vSearchExecutor.makeExecutableExp(pExp, pMakeContext);
            if (vExecExp == null) continue;
            if (vResult == null) {
                vResult = vExecExp;
                continue;
            }
            if (vResult.getExecutor().isCoalescable(vSearchExecutor, pExp, pMakeContext) || vSearchExecutor.isCoalescable(vResult.getExecutor(), pExp, pMakeContext)) {
                if (vExpToCoalesce == null) {
                    vExpToCoalesce = new ArrayList<ISearchExecutableExp>(pExecutors.size());
                }
                vExpToCoalesce.add(vExecExp);
                continue;
            }
            if (vExpToCoalesce == null) continue;
            for (int i = 0; i < vExpToCoalesce.size(); ++i) {
                ISearchExecutor vOtherExecutor = ((ISearchExecutableExp)vExpToCoalesce.get(i)).getExecutor();
                if (!vOtherExecutor.isCoalescable(vSearchExecutor, pExp, pMakeContext) && !vSearchExecutor.isCoalescable(vOtherExecutor, pExp, pMakeContext)) continue;
                vExpToCoalesce.add(vExecExp);
                continue block0;
            }
        }
        if (vExpToCoalesce != null) {
            OrExecExp vCoalesceExp = new OrExecExp(this.getDefaultExecutor());
            ISearchExecutableExp[] vMembers = new ISearchExecutableExp[vExpToCoalesce.size() + 1];
            vMembers[0] = vResult;
            for (int i = 0; i < vExpToCoalesce.size(); ++i) {
                vMembers[i + 1] = (ISearchExecutableExp)vExpToCoalesce.get(i);
            }
            vCoalesceExp.init(vMembers);
            return vCoalesceExp;
        }
        if (vResult == null) {
            throw new Exception("No executor found for : " + pExp);
        }
        return vResult;
    }

    protected ISearchExecutableExp makeExecBooleanExp(ISearchExp pExp, List<ISearchExecutor> pExecutors, MakeExecutableExpContext pMakeContext) throws Exception {
        ISearchExecutableExp vResult = null;
        ISearchExecutor vSoleExecutor = pMakeContext.getSoleExceutor(pExp);
        if (vSoleExecutor != null && vSoleExecutor.isOptimizedForBooleanExp()) {
            vResult = vSoleExecutor.makeExecutableExp(pExp, pMakeContext);
        }
        if (vResult == null) {
            Class<?> vClassExp = pExp.getClass();
            if (vClassExp == And.class) {
                AndExecExp vExecExp = new AndExecExp(this.getDefaultExecutor());
                List<ISearchExp> vMembers = ((And)pExp).getMembers();
                ISearchExecutableExp[] vExecMembers = new ISearchExecutableExp[vMembers.size()];
                pMakeContext.pushExp(pExp);
                for (int i = 0; i < vExecMembers.length; ++i) {
                    vExecMembers[i] = this.makeExecExp(vMembers.get(i), pExecutors, pMakeContext);
                }
                pMakeContext.popExp();
                vExecExp.init(vExecMembers);
                vResult = vExecExp;
            } else if (vClassExp == Or.class) {
                OrExecExp vExecExp = new OrExecExp(this.getDefaultExecutor());
                List<ISearchExp> vMembers = ((Or)pExp).getMembers();
                ISearchExecutableExp[] vExecMembers = new ISearchExecutableExp[vMembers.size()];
                pMakeContext.pushExp(pExp);
                for (int i = 0; i < vExecMembers.length; ++i) {
                    vExecMembers[i] = this.makeExecExp(vMembers.get(i), pExecutors, pMakeContext);
                }
                pMakeContext.popExp();
                vExecExp.init(vExecMembers);
                vResult = vExecExp;
            } else if (vClassExp == Not.class) {
                NotExecExp vExecExp = new NotExecExp(this.getDefaultExecutor());
                ISearchExp vMember = ((Not)pExp).getSubExp();
                pMakeContext.pushExp(pExp);
                vExecExp.init(this.makeExecExp(vMember, pExecutors, pMakeContext));
                pMakeContext.popExp();
                vResult = vExecExp;
            } else {
                throw new AssertionError((Object)("Exp boolenne unknown : " + pExp));
            }
        }
        return vResult;
    }

    protected ISearchExecutableExp makeExecExp(ISearchExp pExp, List<ISearchExecutor> pExecutors, MakeExecutableExpContext pMakeContext) throws Exception {
        if (this.isBooleanExp(pExp)) {
            return this.makeExecBooleanExp(pExp, pExecutors, pMakeContext);
        }
        return pMakeContext.fMapExpLeaf.get(pExp);
    }

    protected boolean isBooleanExp(ISearchExp pExp) {
        Class<?> vClass = pExp.getClass();
        if (vClass == And.class) {
            return true;
        }
        if (vClass == Or.class) {
            return true;
        }
        return vClass == Not.class;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MaxResultsIterator<E>
    implements Iterator<ISearchResultRow> {
        protected int fCount = 0;
        protected Iterator<ISearchResultRow.ISearchResultRowInternal> fSubIt;

        public MaxResultsIterator(Iterator<ISearchResultRow.ISearchResultRowInternal> pSubIt) {
            this.fSubIt = pSubIt;
        }

        @Override
        public boolean hasNext() {
            if (this.fCount < RequestCompiled.this.fMaxResults) {
                return this.fSubIt.hasNext();
            }
            return false;
        }

        @Override
        public ISearchResultRow next() {
            if (this.fCount < RequestCompiled.this.fMaxResults) {
                ++this.fCount;
                return this.fSubIt.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove operation not supported.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MakeExecExpLeaf
    implements ISearchExp.IExpVisitor {
        protected IdentityHashMap<ISearchExp, ISearchExecutableExp> fMapExpLeaf;
        protected List<ISearchExecutor> fExecutors;
        protected ISearchExecutor.IMakeExecutableExpContext fMakeContext;

        public MakeExecExpLeaf(IdentityHashMap<ISearchExp, ISearchExecutableExp> pMapExpLeaf, List<ISearchExecutor> pExecutors, ISearchExecutor.IMakeExecutableExpContext pMakeContext) {
            this.fMapExpLeaf = pMapExpLeaf;
            this.fExecutors = pExecutors;
            this.fMakeContext = pMakeContext;
        }

        @Override
        public boolean visitExp(ISearchExp pExp) throws Exception {
            if (!RequestCompiled.this.isBooleanExp(pExp)) {
                this.fMapExpLeaf.put(pExp, RequestCompiled.this.makeExecLeafExp(pExp, this.fExecutors, this.fMakeContext));
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MakeExecutableExpContext
    implements ISearchExecutor.IMakeExecutableExpContext,
    ISearchExp.IExpVisitor {
        protected ArrayList<ISearchExp> fExpstack = null;
        public IdentityHashMap<ISearchExp, ISearchExecutableExp> fMapExpLeaf = null;
        protected int fVisitType = 0;
        protected ISearchExecutor fSoleExecutor = null;

        protected MakeExecutableExpContext() {
        }

        @Override
        public ISearchRequestCompiled getCompiledRequest() {
            return RequestCompiled.this;
        }

        @Override
        public Iterator<ISearchExp> iterateReducingScope() {
            throw new RuntimeException("TODO : iterateReducingScope");
        }

        @Override
        public void pushExp(ISearchExp pExp) {
            if (this.fExpstack == null) {
                this.fExpstack = new ArrayList(6);
            }
            this.fExpstack.add(pExp);
        }

        @Override
        public void popExp() {
            this.fExpstack.remove(this.fExpstack.size() - 1);
        }

        protected boolean containCoalescedExp(ISearchExp pExp) throws Exception {
            this.fVisitType = 0;
            return !pExp.acceptExpVisitor(this);
        }

        protected ISearchExecutor getSoleExceutor(ISearchExp pExp) throws Exception {
            this.fVisitType = 1;
            this.fSoleExecutor = null;
            pExp.acceptExpVisitor(this);
            return this.fSoleExecutor;
        }

        @Override
        public boolean visitExp(ISearchExp pExp) throws Exception {
            switch (this.fVisitType) {
                case 0: {
                    if (RequestCompiled.this.isBooleanExp(pExp)) {
                        return true;
                    }
                    return this.fMapExpLeaf.get(pExp).getClass() == OrExecExp.class;
                }
                case 1: {
                    if (RequestCompiled.this.isBooleanExp(pExp)) {
                        return true;
                    }
                    ISearchExecutableExp vExecExp = this.fMapExpLeaf.get(pExp);
                    if (this.fSoleExecutor == null) {
                        this.fSoleExecutor = vExecExp.getExecutor();
                    } else if (this.fSoleExecutor != vExecExp.getExecutor()) {
                        this.fSoleExecutor = null;
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }
    }
}

