/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.impl.execexp;

import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutableExp;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchExp;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.And;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import com.scenari.src.search.helpers.util.UnionFiltersIterator;
import eu.scenari.fw.util.collections.CollectionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndExecExp
extends ExecutableExpBase {
    protected ISearchExecutableExp[] fMembers = null;
    protected ISearchExecutableExp fStartSearch = null;

    public AndExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    public AndExecExp init(And pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        List<ISearchExp> vMembers = pExp.getMembers();
        this.fMembers = new ISearchExecutableExp[vMembers.size()];
        pMakeContext.pushExp(pExp);
        for (int i = 0; i < vMembers.size(); ++i) {
            this.fMembers[i] = this.getExecutor().makeExecutableExp(vMembers.get(i), pMakeContext);
        }
        pMakeContext.popExp();
        return this;
    }

    public void init(ISearchExecutableExp[] pMembers) throws Exception {
        this.fMembers = pMembers;
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    @Override
    public boolean isMatchableFalse() throws Exception {
        for (ISearchExecutableExp vMember : this.fMembers) {
            if (vMember.isMatchableFalse() || vMember.isComplementarySearchable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pRows, ISearchContext.ISearchContextInternal pContext) throws Exception {
        if (this.fMode == ISearchExecutableExp.ExecMode.match) {
            Iterator<ISearchResultRow.ISearchResultRowInternal> vItBase = pRows;
            for (ISearchExecutableExp vExecExp : this.fMembers) {
                if (vExecExp.getMode() == ISearchExecutableExp.ExecMode.match) {
                    vItBase = vExecExp.match(vItBase, pContext);
                    continue;
                }
                if (vExecExp.getMode() == ISearchExecutableExp.ExecMode.search) {
                    vItBase = CollectionUtil.newIntersectSortedIterator(vItBase, vExecExp.search(pContext), ISearchResultRow.COMPARATOR_RESULTROW);
                    continue;
                }
                throw new Exception("Wrong compile mode");
            }
            return vItBase;
        }
        if (this.fMode == ISearchExecutableExp.ExecMode.matchFalse) {
            UnionFiltersIterator<ISearchResultRow.ISearchResultRowInternal> vResulIt = new UnionFiltersIterator<ISearchResultRow.ISearchResultRowInternal>(pRows, 512, ISearchResultRow.COMPARATOR_RESULTROW);
            Iterator[] vMatchableIt = new Iterator[this.fMembers.length];
            int vIdx = 0;
            for (ISearchExecutableExp vExecExp : this.fMembers) {
                if (vExecExp.getMode() == ISearchExecutableExp.ExecMode.matchFalse) {
                    vMatchableIt[vIdx++] = vExecExp.match(vResulIt.wrapSourceIterator(), pContext);
                    continue;
                }
                System.arraycopy(vMatchableIt, 0, vMatchableIt, 1, vIdx++);
                vMatchableIt[0] = vExecExp.search(pContext);
            }
            vResulIt.setFiltersIterator(vMatchableIt, vIdx);
            return vResulIt;
        }
        throw new Exception("Wrong compile mode");
    }

    @Override
    public boolean isSearchable() throws Exception {
        for (ISearchExecutableExp vMember : this.fMembers) {
            if (!vMember.isSearchable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplementarySearchable() throws Exception {
        for (ISearchExecutableExp vMember : this.fMembers) {
            if (vMember.isComplementarySearchable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> search(ISearchContext.ISearchContextInternal pContext) throws Exception {
        if (this.fMode == ISearchExecutableExp.ExecMode.search) {
            Iterator<ISearchResultRow.ISearchResultRowInternal> vItBase = this.fStartSearch.search(pContext);
            for (ISearchExecutableExp vExecExp : this.fMembers) {
                if (vExecExp == this.fStartSearch) continue;
                if (vExecExp.getMode() == ISearchExecutableExp.ExecMode.search) {
                    vItBase = CollectionUtil.newIntersectSortedIterator(vItBase, vExecExp.search(pContext), ISearchResultRow.COMPARATOR_RESULTROW);
                    continue;
                }
                if (vExecExp.getMode() == ISearchExecutableExp.ExecMode.match) continue;
                throw new Exception("Wrong compile mode");
            }
            for (ISearchExecutableExp vExecExp : this.fMembers) {
                if (vExecExp == this.fStartSearch || vExecExp.getMode() != ISearchExecutableExp.ExecMode.match) continue;
                vItBase = vExecExp.match(vItBase, pContext);
            }
            return vItBase;
        }
        if (this.fMode == ISearchExecutableExp.ExecMode.complementarySearch) {
            ArrayList<Iterator<Iterator<ISearchResultRow.ISearchResultRowInternal>>> vListUnion = new ArrayList<Iterator<Iterator<ISearchResultRow.ISearchResultRowInternal>>>(this.fMembers.length);
            for (ISearchExecutableExp vExecExp : this.fMembers) {
                vListUnion.add(vExecExp.search(pContext));
            }
            return CollectionUtil.newUnionSortedIterator(vListUnion, ISearchResultRow.COMPARATOR_RESULTROW);
        }
        throw new Exception("Wrong compile mode");
    }

    @Override
    public void compile(ISearchExecutableExp.ExecMode pMode) throws Exception {
        super.compile(pMode);
        switch (pMode) {
            case match: {
                for (ISearchExecutableExp vMember : this.fMembers) {
                    if (vMember.isMatchable()) {
                        vMember.compile(ISearchExecutableExp.ExecMode.match);
                        continue;
                    }
                    vMember.compile(ISearchExecutableExp.ExecMode.search);
                }
                break;
            }
            case matchFalse: {
                for (ISearchExecutableExp vMember : this.fMembers) {
                    if (vMember.isMatchableFalse()) {
                        vMember.compile(ISearchExecutableExp.ExecMode.matchFalse);
                        continue;
                    }
                    vMember.compile(ISearchExecutableExp.ExecMode.complementarySearch);
                }
                break;
            }
            case search: {
                for (ISearchExecutableExp vMember : this.fMembers) {
                    if (this.fStartSearch == null) {
                        if (vMember.isSearchable()) {
                            this.fStartSearch = vMember;
                            vMember.compile(ISearchExecutableExp.ExecMode.search);
                            continue;
                        }
                        vMember.compile(ISearchExecutableExp.ExecMode.match);
                        continue;
                    }
                    if (vMember.isMatchable()) {
                        vMember.compile(ISearchExecutableExp.ExecMode.match);
                        continue;
                    }
                    vMember.compile(ISearchExecutableExp.ExecMode.search);
                }
                break;
            }
            case complementarySearch: {
                for (ISearchExecutableExp vMember : this.fMembers) {
                    vMember.compile(ISearchExecutableExp.ExecMode.complementarySearch);
                }
                break;
            }
        }
    }

    @Override
    public boolean provideData(String pKey) {
        for (ISearchExecutableExp vExp : this.fMembers) {
            if (!vExp.provideData(pKey)) continue;
            return true;
        }
        return false;
    }
}

