/*
 * Decompiled with CFR 0.152.
 */
package com.scenari.src.search.impl.execexp;

import com.scenari.src.search.ISearchContext;
import com.scenari.src.search.ISearchExecutor;
import com.scenari.src.search.ISearchResultRow;
import com.scenari.src.search.exp.RegexpUri;
import com.scenari.src.search.helpers.base.ExecutableExpBase;
import eu.scenari.fw.util.collections.Predicate;
import eu.scenari.fw.util.collections.PredicateFilterIterator;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpUriExecExp
extends ExecutableExpBase {
    protected Pattern fRegexp = null;

    public RegexpUriExecExp(ISearchExecutor pExecutor) {
        super(pExecutor);
    }

    public RegexpUriExecExp init(RegexpUri pExp, ISearchExecutor.IMakeExecutableExpContext pMakeContext) throws Exception {
        this.fRegexp = pExp.getRegexp();
        return this;
    }

    @Override
    public boolean isMatchable() throws Exception {
        return true;
    }

    @Override
    public Iterator<ISearchResultRow.ISearchResultRowInternal> match(Iterator<ISearchResultRow.ISearchResultRowInternal> pRows, ISearchContext.ISearchContextInternal pContext) throws Exception {
        return new RegexpUriFilterIt(pRows, this.matchValue()).setPredicateAsSelf();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RegexpUriFilterIt
    extends PredicateFilterIterator<ISearchResultRow.ISearchResultRowInternal>
    implements Predicate<ISearchResultRow.ISearchResultRowInternal> {
        protected boolean fResultAttempted;

        public RegexpUriFilterIt(Iterator<ISearchResultRow.ISearchResultRowInternal> pFrom, boolean pResultAttempted) {
            super(pFrom);
            this.fResultAttempted = pResultAttempted;
        }

        @Override
        public boolean match(ISearchResultRow.ISearchResultRowInternal pEntry) {
            String vUri = pEntry.getRowUri();
            if (vUri == null) {
                return false;
            }
            return RegexpUriExecExp.this.fRegexp.matcher(vUri).matches() == this.fResultAttempted;
        }
    }
}

